<?php $__env->startSection('content'); ?>
  <header class="text-align-center">
    <span><img src="<?php echo e(url('image/logo.png')); ?>" style="width: 150px; margin-bottom: 10px;"></span>
    <h4>-: PAYMENT FORM :-</h4>
    <h4> Registration Fee: Rs. 1500/- </h4>
  </header>

  <div class="body">
    <div id="w0"></div>
    <form id="submit_form" action="<?php echo e(route('payment.registration')); ?>" method="post">
      <?php echo csrf_field(); ?>
      <fieldset>
        <div class="form-group">
          <div id="pub">
            <div class="form-group field-name required">
              <label class="control-label" for="name">Name</label>
              <input type="text" id="name" class="form-control" name="name" placeholder="First and last name" onkeydown="hideError()">
              <div class="help-block"></div>
            </div>

            <div class="form-group field-email required">
              <label class="control-label" for="email">Email</label>
              <input type="text" id="email" class="form-control" name="email" placeholder="example@domain.com" onkeydown="hideError()">
              <div class="help-block"></div>
            </div>

            <div class="form-group field-phone required">
              <label class="control-label" for="phone">Phone</label>
              <input type="text" id="phone" class="form-control" name="phone" placeholder="WhatsApp number" onkeydown="hideError()">
              <div class="help-block"></div>
            </div>

            <div class="form-group field-category required">
              <label class="control-label" for="category">Talent Category</label>
              <select id="category" class="form-control" name="category" onchange="hideError()">
                <option value="" selected disabled>Choose your category</option>
                <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <option value="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php endif; ?>
              </select>
              <div class="help-block"></div>
            </div>

            <div class="form-group field-gender required">
              <label class="control-label" for="gender">Gender</label>
              <select id="gender" class="form-control" name="gender" onchange="hideError()">
                <option value="" selected disabled>Select gender</option>
                <option value="male">Male</option>
                <option value="female">Female</option>
                <option value="other">Other</option>
              </select>
              <div class="help-block"></div>
            </div>

            <div class="form-group field-age-group required">
              <label class="control-label" for="age-group">Age Group</label>
              <select id="age-group" class="form-control" name="age_group" onchange="hideError()">
                <option value="" selected disabled>Select age group</option>
                <option value="junior">Junior (5 to 15)</option>
                <option value="senior">Senior (16 to 45)</option>
              </select>
              <div class="help-block"></div>
            </div>

            <div class="form-group select2-cnt field-state required">
              <label class="control-label" for="state">State</label>
              <select class="form-control selectpicker" id="select-state" name="state" data-live-search="true" onchange="hideError()">
                <option value="" selected>Select your state</option>
                <?php $__empty_1 = true; $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <option value="<?php echo e($state->code); ?>"><?php echo e($state->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php endif; ?>
              </select>
              <div class="help-block"></div>
            </div>

            <div class="form-group select2-cnt field-city required">
              <label class="control-label" for="city">City</label>
              <select class="form-control selectpicker" id="select-city" name="city" data-live-search="true" onchange="hideError()">
                <option value="" selected>Select your state first</option>
              </select>
              <div class="help-block"></div>
            </div>

            <?php if($admin->membership == 1): ?>
            <div class="form-group field-membership required">
              <label class="control-label" for="membership">Registration</label>
              <select id="membership" class="form-control" name="membership" onchange="hideError()">
                <option value="1" selected>Membership (1 Year) - Fee: Rs. 1500/-</option>
                <option value="0">Audition (One Time) - Fee: Rs. 750/-</option>
              </select>
              <div class="help-block"></div>
            </div>
            <?php endif; ?>
            
            <br>
          </div>
        </div>
      </fieldset>

      <div class="form-actions">
        <div class="errorText" style="color: red;margin-bottom: 8px;margin-top: -8px;margin-left: 5px;"></div>
        <button type="button" class="btn btn-block btn-lg btn-danger onClickSubmit">
          <span class="small-circle"><i class="fa fa-caret-right"></i></span>
          <small class="onSubmit">Pay Now</small>
        </button>
        
        <?php echo $__env->make('common.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      </div>
    </form>
  </div>
<?php $__env->stopSection(); ?>
  
<?php $__env->startSection('script'); ?>
  <script>
    $(function() {
      $('.selectpicker').selectpicker();
    });

    function hideError(){
      $(".errorText").text('');
    }
  </script>

  <script type="text/javascript">
    (function($) {
      $.fn.inputFilter = function(inputFilter) {
        return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function() {
          if (inputFilter(this.value)) {
            this.oldValue = this.value;
            this.oldSelectionStart = this.selectionStart;
            this.oldSelectionEnd = this.selectionEnd;
          } else if (this.hasOwnProperty("oldValue")) {
            this.value = this.oldValue;
            this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
          } else {
            this.value = "";
          }
        });
      };
    }(jQuery));

    $("#phone").inputFilter(function(value) {
      return /^\d*$/.test(value) && (value === "" || parseInt(value) <= 9999999999);
    });
  </script>
  
  <script type="text/javascript">
    $(document).ready(function(){
      $("#select-state").on('change', function(){
        var state_code = $(this).val();
        var CSRF_TOKEN = "<?php echo e(csrf_token()); ?>";

        $.ajax({
          url: "<?php echo e(route('getCities')); ?>",
          type: "POST",
          data:{_token: CSRF_TOKEN, state_code: state_code},
          success:function(data){
            var options = [];
            var src = data;

            src.forEach(function (item) {
              var option = "<option value='"+ item.slug +"'>" + item.name + "</option>"
              options.push(option);
            });
            $('#select-city').html('<option value="" selected>Select your city</option>'+options);
            $('#select-city').selectpicker('refresh');
          }
        });
      })

      $(".onClickSubmit").on('click', function(){
        var name = $("#name").val();
        if(name == ''){
          $(".errorText").text('* Name field is empty.');
          return false;
        }

        var email = $("#email").val();
        if(email == ''){
          $(".errorText").text('* Email field is empty.');
          return false;
        }
        else{
          var emailRegex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
          if(!emailRegex.test(email)){
            $(".errorText").text('* Email not valid.');
            return false;
          }
        }

        var phone = $("#phone").val();
        if(phone == ''){
          $(".errorText").text('* Phone field is empty.');
          return false;
        }

        var phone = $("#phone").val();
        if(phone.length < 10){
          $(".errorText").text('* Enter a valid phone number.');
          return false;
        }

        var category = $("#category").val();
        if(category == '' || category == null){
          $(".errorText").text('* Talent category field is empty.');
          return false;
        }

        var gender = $("#gender").val();
        if(gender == '' || gender == null){
          $(".errorText").text('* Gender field is empty.');
          return false;
        }

        var age_group = $("#age-group").val();
        if(age_group == '' || age_group == null){
          $(".errorText").text('* Age group field is empty.');
          return false;
        }

        var select_state = $("#select-state").val();
        if(select_state == ''){
          $(".errorText").text('* State field is empty.');
          return false;
        }

        var select_city = $("#select-city").val();
        if(select_city == ''){
          $(".errorText").text('* City field is empty.');
          return false;
        }

        var CSRF_TOKEN = "<?php echo e(csrf_token()); ?>";
        $(".onSubmit").text('Please Wait...');
        $(this).attr('disabled');

        $.ajax({
          url: "<?php echo e(route('payment.checkRegistration')); ?>",
          type: "POST",
          data:{_token: CSRF_TOKEN,
            name: name,
            email: email,
            phone: phone,
            category: category,
            gender: gender,
            age_group: age_group,
            state: select_state,
            city: select_city,
          },
          success:function(data){
            if(data == 0){
              $('#submit_form').get(0).submit();
              // $(".onSubmit").text('Pay Now');
            }
            else{
              swal("Yeah!", "You have already submitted your registration fees.");
              $(".onSubmit").text('Pay Now');
              $(this).removeAttr('disabled');
            }
          },
          error: function(data){
            $(".onSubmit").text('Pay Now');
            $(this).removeAttr('disabled');
            $(".errorText").text('* '+data.responseJSON.errors);
          }
        })
      });
    });
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\MY\talentriangle\talentriangle\resources\views/payment.blade.php ENDPATH**/ ?>