

<?php $__env->startSection('style'); ?>
	<style type="text/css">
		.btn-sm-new{
			padding: 8px 10px;
		    line-height: 16px;
		    font-size: 17px;
		}
	</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-6">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Audition List</h5>
							<span>Audition Management</span>
						</div>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="page-header-breadcrumb">
						<ul class=" breadcrumb breadcrumb-title">
							<li class="breadcrumb-item">
								<?php if($type == 1): ?>
									<a href="<?php echo e(route('auditions.admin.audition.export',[$type])); ?>" class="btn btn-primary waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Export Data">
										Export Data
									</a>
								<?php endif; ?>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-last-message">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="dt-responsive table-responsive text-center">
											<span style="font-weight: 600">From Date:</span>
											<input type="date" name="from_date" id="from_date">&nbsp;&emsp;
											<!-- <i class="icon-calendar" onclick="onClickFromDate()" style="font-size: 25px;position: absolute;margin: 2px 0px; cursor: pointer;"></i>&emsp;&emsp;&emsp;&emsp; -->

											<span style="font-weight: 600">To Date:</span>
											<input type="date" name="to_date" id="to_date">&emsp;&emsp;&emsp;&emsp;

											<button class="btn btn-sm btn-success" onclick="onClickMoveToLast()">Move to Last Date Section</button>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-selfie" style="display: none;">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="dt-responsive table-responsive list_selfie">
											<?php echo $__env->make('audition-admin.result.selected.ajax-selfie', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-data">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="dt-responsive table-responsive list_data">
											<?php echo $__env->make('audition-admin.result.selected.ajax-list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
	<script type="text/javascript">
        jQuery(function() {
        	$('#from-date').dateDropper({
			  format: 'Y-m-d',
			  large: true
			});

			$('#to-date').dateDropper({
			  format: 'Y-m-d'
			});

            jQuery('body').on('click', '.pagination a', function(e) {
				
                e.preventDefault();

                jQuery('#load a').css('color', '#dfecf6');
                // jQuery('#load').append('<img style="position: absolute; left: 0; top: 0; z-index: 100000;" src="images/loader.gif" />');

                var url = jQuery(this).attr('href');

                // check if search field non empty
                var keyword = $(".keyword").val();

                if(keyword == ''){
                	getArticles(url);
                }
                else{
                	getArticlesWithKeyword(url, keyword);
                }
                
                // window.history.pushState("", "", url);
            });

            function getArticles(url) {
                jQuery.ajax({
                    url : url
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }

            function getArticlesWithKeyword(url, keyword) {
                jQuery.ajax({
                    url : url,
                    data: {search:keyword}
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }
        });

		function onClickPlay(rid) {
	    	jQuery.ajax({
	            url : "<?php echo e(route('auditions.admin.audition.selfie.selected')); ?>",
	            data: {registration_id: rid}
	        }).done(function (data) {
	            $(".show-hide-data").hide();
	            $(".show-hide-selfie").show();
	            jQuery('.list_selfie').html(data);
	        }).fail(function () {
	            alert('Articles could not be loaded.');
	        });
	    }

	    function onClickDeleteAuditionVideo(rid) {
	    	jQuery.ajax({
	            url : "<?php echo e(route('auditions.admin.audition.selfie.delete')); ?>",
	            data: {registration_id: rid}
	        }).done(function (data) {
	            swal("Videos successfully deleted");
	            getArticlesNew();
	        }).fail(function () {
	            alert('Articles could not be loaded.');
	        });
	    }

	    function onClickSendSMS(rid, type) {
	    	jQuery.ajax({
	            url : "<?php echo e(route('auditions.admin.audition.selfie.sendsms')); ?>",
	            data: {registration_id: rid, type: type}
	        }).done(function (data) {
	        	if(data == 2){
	        		swal("First you need to add messages.", {
						buttons: {
							yes: {
								text: "OK",
								value: "yes",
							},
						},
					})
					.then((value) => {
					  location.href = "<?php echo e(route('auditions.admin.message.index')); ?>";
					});
	        	}
	        	else{
	        		swal("SMS sent successfully");
	        	}
	        }).fail(function () {
	            alert('Something wents wrong.');
	        });
	    }

	    function onClickCancel() {
	    	getArticlesNew();
	    }

	    function onClickResult(rid, result) {
	    	if(result == 1){
	    		var data = {registration_id: rid, result: result}
	    	}

	    	if(result == 2){
	    		var data = {registration_id: rid, result: result}
	    	}

	    	if(result == 3){
	    		var feedback = $("#message_re_invite").val();
	    		var data = {registration_id: rid, result: result, feedback: feedback}
	    	}

	    	jQuery.ajax({
	            url : "<?php echo e(route('auditions.admin.audition.selfie.result')); ?>",
	            data: data
	        }).done(function (data) {
	        	if(data == 4){
	        		swal("First you need to add messages list.", {
						buttons: {
							yes: {
								text: "OK",
								value: "yes",
							},
						},
					})
					.then((value) => {
					  location.href = "<?php echo e(route('auditions.admin.message.index')); ?>";
					});
	        	}
	        	else{
	        		getArticlesNew();
		            if(data == 3){
		            	$('#Re-Invite-Modal').modal('hide');
		            }
	        	}
	        }).fail(function () {
	            alert('Articles could not be loaded.');
	        });
	    }

	    function onClickBest(rid) {
	    	var data = {registration_id: rid}

	    	jQuery.ajax({
	            url : "<?php echo e(route('auditions.admin.audition.selfie.best')); ?>",
	            data: data
	        }).done(function (data) {
	        	swal("Audition successfully marked as best.");
	        }).fail(function () {
	            alert('Something wents wrong.');
	        });
	    }

	    function getArticlesNew() {
	    	$("video").each(function () { this.pause() });
	    	
	    	var url = jQuery(this).attr('href');

	    	jQuery.ajax({
                url : url
            }).done(function (data) {
                jQuery('.list_data').html(data);
                $(".show-hide-data").show();
	        	$(".show-hide-selfie").hide();
            }).fail(function () {
                alert('Articles could not be loaded.');
            });
	    }

	    function enterMessage(value) {
	    	var message = $("#message").val();
	    	$("#message").val(message+value);
	    }

	    function enterMessageReject(value) {
	    	var message = $("#message_reject").val();
	    	$("#message_reject").val(message+value);
	    }

	    function enterMessageReInvite(value) {
	    	var message = $("#message_re_invite").val();
	    	$("#message_re_invite").val(message+value);
	    }

	    function onClickFromDate() {
	    	document.getElementById("from_date").focus();
	    }

	    function onClickMoveToLast() {
	    	var from_date = $('#from_date').val();
	    	var to_date = $('#to_date').val();

	    	jQuery.ajax({
	            url : "<?php echo e(route('auditions.admin.audition.selfie.move-to-last')); ?>",
	            data: {from_date: from_date, to_date: to_date}
	        }).done(function (data) {
	        	if(data == 4){
	        		swal("First you need to add messages list with last message field.", {
						buttons: {
							yes: {
								text: "OK",
								value: "yes",
							},
						},
					})
					.then((value) => {
					  location.href = "<?php echo e(route('auditions.admin.message.index')); ?>";
					});
	        	}
	        	else{
	        		getArticlesNew();
	        	}
	        }).fail(function () {
	            alert('Articles could not be loaded.');
	        });
	    }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('audition-admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/talentri/public_html/talentriangle/resources/views/audition-admin/result/selected/list.blade.php ENDPATH**/ ?>