
<?php $__env->startSection('content'); ?>

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Payments List</h5>
							<span>Payments Management</span>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="page-header-breadcrumb">
						<ul class=" breadcrumb breadcrumb-title">
							<li class="breadcrumb-item">
								<button type="button" class="btn btn-primary btn-sm waves-effect waves-light onClickShowHide">
									<i class="icon-plus"></i> Export Data
								</button>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-export" style="display: none;">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<h1 style="text-align: center;">Total Count: <span class="export-data-count">XXX</span></h1>
										<form id="export-form" action="<?php echo e(route('admin.payments.export')); ?>" method="POST">
		                                    <?php echo csrf_field(); ?>
		                                    <div class="row">
												<div class="col-sm-12">
													<label class="col-form-label">Category :</label>
													<select class="js-example-basic-single col-sm-12 category" name="category" id="category" style="width: 100%">
														<option disabled selected>Select Category</option>
														<option value="all">All</option>
														<?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
										                    <option value="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></option>
										                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
										                <?php endif; ?>
													</select>
												</div>
											</div>
											<div class="row">
												<div class="col-sm-6">
													<label class="col-form-label">From Date :</label>
													<input id="from-date" class="form-control from_date" name="from_date" type="text" placeholder="Select your date" />
												</div>
												<div class="col-sm-6">
													<label class="col-form-label">To Date :</label>
													<input id="to-date" class="form-control to_date" name="to_date" type="text" placeholder="Select your date" />
												</div>
											</div>
		                                </form><br>
		                                <a href="<?php echo e(route('admin.payments.export')); ?>" onclick="event.preventDefault(); document.getElementById('export-form').submit();" class="btn btn-primary waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Download Data">
											Download Data
										</a>
										<button class="btn btn-primary waves-effect waves-light onClickGetDataCount" data-toggle="tooltip" data-placement="top" title="Get Data Count">
											Get Data Count
										</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-6">
												<div class="form-radio m-b-30">
													<div class="radio radiofill radio-success radio-inline">
														<label>
															<input type="radio" class="status" name="status" checked="checked" value="2" onchange="return getSearchArticlesByStatus(this.value);">
															<i class="helper"></i>Paid
														</label>
													</div>
													<div class="radio radiofill radio-info radio-inline">
														<label>
															<input type="radio" class="status" name="status" value="0" onchange="return getSearchArticlesByStatus(this.value);">
															<i class="helper"></i>Pending
														</label>
													</div>
													<div class="radio radiofill radio-warning radio-inline">
														<label>
															<input type="radio" class="status" name="status" value="1" onchange="return getSearchArticlesByStatus(this.value);">
															<i class="helper"></i>All
														</label>
													</div>
												</div>
											</div>
											<div class="col-sm-6">
												<input type="text" name="search" placeholder="Search by name, email, phone ..." class="form-control keyword" onkeyup="return getSearchArticles(this.value);"><br>
											</div>
										</div>
										<div class="dt-responsive table-responsive list_data">
											<?php echo $__env->make('admin.payments.ajax-list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

	<script type="text/javascript">
		function onClickDelete(id) {
			swal("Are you sure? want to delete.", {
				buttons: {
					yes: {
						text: "Yes",
						value: "yes",
					},
					no: {
						text: "No",
						value: "no",
					}
				},
			})
			.then((value) => {
			  switch (value) {
			    case "yes":
			      $('#delete-from-'+id).get(0).submit();
			      break;
			 
			    case "no":
			      break;
			 
			    default:
			      swal("Got away safely!");
			  }
			});
		}

		function onClickSend(id) {
			$.ajax({
                url : "<?php echo e(route('admin.payments.send.message')); ?>",
                data: {id: id}
            }).done(function (data) {
                swal("Message Sent Successfully");
            }).fail(function () {
                alert('Someting wents wrong.');
            });
		}
	</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<script type="text/javascript">
        jQuery(function() {
        	$('#from-date').dateDropper({
			  format: 'Y-m-d',
			  large: true
			});

			$('#to-date').dateDropper({
			  format: 'Y-m-d'
			});

            jQuery('body').on('click', '.pagination a', function(e) {
				
                e.preventDefault();

                jQuery('#load a').css('color', '#dfecf6');
                // jQuery('#load').append('<img style="position: absolute; left: 0; top: 0; z-index: 100000;" src="images/loader.gif" />');

                var url = jQuery(this).attr('href');

                // check if search filed non empty
                var keyword = $(".keyword").val();

                if(keyword == ''){
                	getArticles(url);
                }
                else{
                	getArticlesWithKeyword(url, keyword);
                }
                
                // window.history.pushState("", "", url);
            });

            function getArticles(url) {
                jQuery.ajax({
                    url : url
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }

            function getArticlesWithKeyword(url, keyword) {
                jQuery.ajax({
                    url : url,
                    data: {search:keyword}
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }
        });

		function getSearchArticles(keyword) {
			var url = window.location.href;
			var status = $(".status:checked").val();
			
			if(status == 0 || status == 1 || status == 2){
				var data = { search:keyword, status:status };
			}
			else{
				var data = { search:keyword }
			}

			jQuery.ajax({
				url : url,
				data: data
			}).done(function (data) {
				jQuery('.list_data').html(data);
			}).fail(function () {
				alert('Articles could not be loaded.');
			});
		}

		function getSearchArticlesByStatus(status) {
			var url = window.location.href;
			jQuery.ajax({
				url : url,
				data: {status:status}
			}).done(function (data) {
				jQuery('.list_data').html(data);
			}).fail(function () {
				alert('Articles could not be loaded.');
			});
		}
    </script>
    <script type="text/javascript">
    	$(document).ready(function(){
    		$(".onClickShowHide").on('click', function() {
    			$(".export-data-count").text("XXX");
    			$(".show-hide-export").toggle();
    		})

    		$(".onClickGetDataCount").on('click', function() {
    			var category = $(".category").val();
    			var from_date = $(".from_date").val();
    			var to_date = $(".to_date").val();

    			$.ajax({
                    url : "<?php echo e(route('admin.payments.export.count')); ?>",
                    data: {category: category, from_date: from_date, to_date: to_date}
                }).done(function (data) {
                    // console.log(data);
                    $(".export-data-count").text(data);
                }).fail(function () {
                    alert('Someting wents wrong.');
                });
    		})
    	})
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/talentri/public_html/talentriangle/resources/views/admin/payments/list.blade.php ENDPATH**/ ?>