<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Talentriangle
Route::get('/dance', function () {
    return view('dance');
});

// registration through main page
Route::get('/', 'HomeController@index')->name('home');

// registration through seo
Route::get('/registration', 'HomeController@seo')->name('seo');

Route::post('getCities', 'HomeController@getCities')->name('getCities');
Route::post('registration', 'HomeController@registration')->name('registration');
Route::get('success', 'HomeController@success')->name('success');
Route::post('checkRegistration', 'HomeController@checkRegistration')->name('checkRegistration');

// Contestant login & Dashboard
Route::get('audition', 'AuditionController@audition')->name('audition.login');
Route::post('audition', 'AuditionController@auditionLogin')->name('audition.login.check');
Route::get('audition/form', 'AuditionController@auditionForm')->name('audition.form.fill');
Route::post('audition/form', 'AuditionController@auditionFormSubmit')->name('audition.form.submit');
Route::get('audition/dashboard', 'AuditionController@dashboard')->name('audition.dashboard');
Route::get('audition/selfie-video', 'AuditionController@selfieVideo')->name('audition.selfie.video');
Route::get('audition/result', 'AuditionController@selfieResult')->name('audition.selfie.result');
Route::post('audition/selfieUpload', 'AuditionController@selfieUpload')->name('audition.selfie.upload');
Route::get('audition/selfieRemove/{id}', 'AuditionController@selfieRemove')->name('audition.selfie.remove');
Route::post('audition/selfieSubmit', 'AuditionController@selfieSubmit')->name('audition.selfie.submit');
Route::post('audition/logout', 'AuditionController@logout')->name('audition.logout');

// Payment
Route::get('payment', 'PaymentController@index')->name('payment');
Route::post('payment', 'PaymentController@registration')->name('payment.registration');
Route::post('checkPaymentRegistration', 'PaymentController@checkPaymentRegistration')->name('payment.checkRegistration');

Route::post('paytm/payment/status', 'PaymentController@paymentCallback');
Route::get('payment/status', 'PaymentController@paymentCallbackGetMethod')->name('payment.status');

// Contestant login & Dashboard
Route::get('contestant', 'ContestantController@contestant')->name('contestant.login');
Route::post('contestant', 'ContestantController@contestantLogin')->name('contestant.login.check');
Route::get('contestant/dashboard', 'ContestantController@dashboard')->name('contestant.dashboard');
Route::post('contestant/selfieUpload', 'ContestantController@selfieUpload')->name('contestant.selfie.upload');
Route::get('contestant/selfieRemove/{id}', 'ContestantController@selfieRemove')->name('contestant.selfie.remove');
Route::post('contestant/selfieSubmit', 'ContestantController@selfieSubmit')->name('contestant.selfie.submit');
Route::post('contestant/logout', 'ContestantController@logout')->name('contestant.logout');

// Auth::routes();

Auth::routes([
  'register' => false, // Registration Routes...
  'reset' => false, // Password Reset Routes...
  'verify' => false, // Email Verification Routes...
]);

/*
|--------------------------------------------------------------------------
| Admin Role
|--------------------------------------------------------------------------
*/

Route::group(['middleware' => ['role:admin'], 'prefix' => 'admin', 'namespace' => 'Admin', 'as'=>'admin.'], function () {

    // Dashboard
	Route::get('home', 'HomeController@index')->name('home');

	// Season Management
	Route::resource('seasons', 'SeasonController');

	// Category Management
	Route::resource('categories', 'CategoryController');

	// Registration Management
	Route::resource('registrations', 'RegistrationController');
	Route::post('registration/export', 'RegistrationController@export')->name('registrations.export');
	Route::get('registration/export/count', 'RegistrationController@exportCount')->name('registrations.export.count');

	// Payment Management
	Route::resource('payments', 'PaymentController');
	Route::get('payment/onetime', 'PaymentController@onetime')->name('payments.onetime');
	Route::post('payment/export', 'PaymentController@export')->name('payments.export');
	Route::get('payment/send/message', 'PaymentController@sendMessage')->name('payments.send.message');
	Route::get('payment/export/count', 'PaymentController@exportCount')->name('payments.export.count');

	// Contestant Admin Management
	Route::resource('contestant-admins', 'ContestantAdminController');

	// Audition lists
	Route::get('contestants', 'ContestantController@index')->name('contestant.list');

	// Audition Admin Management
	Route::resource('audition-admins', 'AuditionAdminController');

	// Audition lists
	Route::get('auditions', 'AuditionController@index')->name('audition.list');
	Route::post('audition-export', 'AuditionController@export')->name('audition.export');

	// Message Management
	Route::get('message', 'MessageController@index')->name('message.index');
	Route::post('message/send', 'MessageController@sendMessage')->name('message.send');

	Route::resource('mail-setting', 'MailSettingController');

	// Mail Management
	Route::get('mail', 'MailController@index')->name('mail.index');
	Route::post('mail/send', 'MailController@sendMail')->name('mail.send');

	// Setting Management
	Route::resource('settings', 'SettingController');
});

/*
|--------------------------------------------------------------------------
| Contestant Admin
|--------------------------------------------------------------------------
*/
Route::get('contestant/login', 'Contestant\LoginController@login')->name('contestants.login');
Route::post('contestant/login', 'Contestant\LoginController@checkLogin')->name('contestants.login.check');
Route::post('contestant-admin/logout', 'Contestant\LoginController@logout')->name('contestants.logout');

Route::group(['prefix' => 'contestant-admin', 'namespace' => 'Contestant', 'as'=>'contestants.'], function () {

    // Dashboard
	Route::get('dashboard', 'DashboardController@dashboard')->name('admin.dashboard');

	// Feedback List
	Route::get('feedback-list', 'FeedbackController@index')->name('admin.feedback.list');
	Route::get('feedback-list/create', 'FeedbackController@create')->name('admin.feedback.create');
	Route::post('feedback-list', 'FeedbackController@store')->name('admin.feedback.store');
	Route::get('feedback-list/{id}/edit', 'FeedbackController@edit')->name('admin.feedback.edit');
	Route::put('feedback-list/{id}', 'FeedbackController@update')->name('admin.feedback.update');
	Route::delete('feedback-list/{id}', 'FeedbackController@destroy')->name('admin.feedback.destroy');
	Route::get('feedback-store', 'FeedbackController@storeFeedback')->name('admin.contestant.selfie.feedback.store');

	// Contestant List
	Route::get('contestant-list', 'ContestantController@contestantList')->name('admin.contestant.list');
	Route::get('contestant-selfie', 'ContestantController@contestantSelfie')->name('admin.contestant.selfie');
	Route::get('contestant-selfie-result', 'ContestantController@contestantSelfieResult')->name('admin.contestant.selfie.result');
	Route::get('contestant-selfie-best', 'ContestantController@contestantSelfieBest')->name('admin.contestant.selfie.best');
	Route::get('contestant-selfie-average', 'ContestantController@contestantSelfieAverage')->name('admin.contestant.selfie.average');
	Route::get('contestant-selfie-reject', 'ContestantController@contestantSelfieReject')->name('admin.contestant.selfie.reject');
	Route::get('contestant-selfie-feedback', 'ContestantController@contestantSelfieFeedback')->name('admin.contestant.selfie.feedback');
	Route::get('contestant-selfie-delete', 'ContestantController@contestantSelfieDelete')->name('admin.contestant.selfie.delete');

	// Best List
	Route::get('best-list', 'ResultController@bestList')->name('admin.best.list');

	// Average List
	Route::get('average-list', 'ResultController@averageList')->name('admin.average.list');

	// Rejected List
	Route::get('rejected-list', 'ResultController@rejectedList')->name('admin.rejected.list');

	// Pending List
	Route::get('pending-list', 'ResultController@pendingList')->name('admin.pending.list');
});

/*
|--------------------------------------------------------------------------
| Audition Admin
|--------------------------------------------------------------------------
*/
Route::get('audition/login', 'Audition\LoginController@login')->name('auditions.login');
Route::post('audition/login', 'Audition\LoginController@checkLogin')->name('auditions.login.check');
Route::post('audition-admin/logout', 'Audition\LoginController@logout')->name('auditions.logout');

Route::group(['prefix' => 'audition-admin', 'namespace' => 'Audition', 'as'=>'auditions.admin.'], function () {

    // Dashboard
	Route::get('dashboard', 'DashboardController@dashboard')->name('dashboard');

	// Message
	Route::resource('message', 'MessageController');

	// Audition List
	Route::get('audition-list', 'AuditionController@index')->name('audition.list');
	Route::get('audition-best-list', 'AuditionController@best')->name('audition.best.list');
	Route::get('audition-seleted-list', 'AuditionController@seleted')->name('audition.seleted.list');
	Route::get('audition-rejeted-list', 'AuditionController@rejected')->name('audition.rejeted.list');
	Route::get('audition-reinvite-list', 'AuditionController@reinvite')->name('audition.re-invite.list');
	Route::get('audition-last-message-list', 'AuditionController@lastMessage')->name('audition.last-message.list');
	Route::get('audition-non-submit-list', 'AuditionController@nonSubmit')->name('audition.non-submit.list');
	Route::get('audition-deleted-video-list', 'AuditionController@deletedVideo')->name('audition.deleted-video.list');
	Route::get('audition-selfie', 'AuditionController@auditionSelfie')->name('audition.selfie');
	Route::get('audition-best', 'AuditionController@auditionBest')->name('audition.best');
	Route::get('audition-selfie-last', 'AuditionController@auditionSelfieLast')->name('audition.selfie.last');
	Route::get('audition-selfie-seleted', 'AuditionController@auditionSelfieSeleted')->name('audition.selfie.selected');
	Route::get('audition-selfie-delete', 'AuditionController@auditionSelfieDelete')->name('audition.selfie.delete');
	Route::get('audition-selfie-delete-list', 'AuditionController@auditionSelfieDeleteList')->name('audition.selfie.delete.list');
	Route::get('audition-selfie-result', 'AuditionController@auditionSelfieResult')->name('audition.selfie.result');
	Route::get('audition-selfie-best', 'AuditionController@auditionSelfieBest')->name('audition.selfie.best');
	Route::get('audition-selfie-move-to-last', 'AuditionController@auditionSelfieMoveToLast')->name('audition.selfie.move-to-last');
	Route::get('audition-export/{type}', 'AuditionController@export')->name('audition.export');
	Route::get('audition-selfie-change-category', 'AuditionController@auditionSelfieChangeCategory')->name('audition.selfie.change.category');
	Route::get('audition-selfie-sendsms', 'AuditionController@auditionSelfieSendsms')->name('audition.selfie.sendsms');

	// Edit details of registered user
	Route::get('audition-edit/{id}', 'AuditionController@edit')->name('audition.edit');
	Route::put('audition-update/{id}', 'AuditionController@update')->name('audition.update');
});