@extends('contestant-admin.layouts.app')

@section('style')
<style type="text/css">
	.btn-sm{
		margin: 0 10px;
	}
</style>
@endsection

@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Selies List</h5>
							<span>Selies Management</span>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="page-header-breadcrumb">
						<ul class=" breadcrumb breadcrumb-title">
							<li class="breadcrumb-item"></li>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-selfie" style="display: none;">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="dt-responsive table-responsive list_selfie">
											@include('contestant-admin.result.rejected.ajax-selfie')
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-data">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-6">
												<input type="text" name="search" placeholder="Search by name, email, phone ..." class="form-control keyword" onkeyup="return getSearchArticles(this.value);"><br>
											</div>
										</div>
										<div class="dt-responsive table-responsive list_data">
											@include('contestant-admin.result.rejected.ajax-list')
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

	<script type="text/javascript">
		function onClickDelete(id) {
			swal("Are you sure? want to delete.", {
				buttons: {
					yes: {
						text: "Yes",
						value: "yes",
					},
					no: {
						text: "No",
						value: "no",
					}
				},
			})
			.then((value) => {
			  switch (value) {
			    case "yes":
			      $('#delete-from-'+id).get(0).submit();
			      break;
			 
			    case "no":
			      break;
			 
			    default:
			      swal("Got away safely!");
			  }
			});
		}

		function onClickSend(id) {
			$.ajax({
                url : "{{ route('admin.payments.send.message') }}",
                data: {id: id}
            }).done(function (data) {
                swal("Message Sent Successfully");
            }).fail(function () {
                alert('Someting wents wrong.');
            });
		}
	</script>

@endsection

@section('script')
	<script type="text/javascript">
        jQuery(function() {
        	$('#from-date').dateDropper({
			  format: 'Y-m-d',
			  large: true
			});

			$('#to-date').dateDropper({
			  format: 'Y-m-d'
			});

            jQuery('body').on('click', '.pagination a', function(e) {
				
                e.preventDefault();

                jQuery('#load a').css('color', '#dfecf6');
                // jQuery('#load').append('<img style="position: absolute; left: 0; top: 0; z-index: 100000;" src="images/loader.gif" />');

                var url = jQuery(this).attr('href');

                // check if search filed non empty
                var keyword = $(".keyword").val();

                if(keyword == ''){
                	getArticles(url);
                }
                else{
                	getArticlesWithKeyword(url, keyword);
                }
                
                // window.history.pushState("", "", url);
            });

            function getArticles(url) {
                jQuery.ajax({
                    url : url
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }

            function getArticlesWithKeyword(url, keyword) {
                jQuery.ajax({
                    url : url,
                    data: {search:keyword}
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }
        });

		function getSearchArticles(keyword) {
			var url = window.location.href;
			jQuery.ajax({
				url : url,
				data: {search:keyword}
			}).done(function (data) {
				jQuery('.list_data').html(data);
			}).fail(function () {
				alert('Articles could not be loaded.');
			});
		}

		function getSearchArticlesByStatus(status) {
			var url = window.location.href;
			jQuery.ajax({
				url : url,
				data: {status:status}
			}).done(function (data) {
				jQuery('.list_data').html(data);
			}).fail(function () {
				alert('Articles could not be loaded.');
			});
		}

		function onClickPlay(rid, season) {
	    	jQuery.ajax({
	            url : "{{route('contestants.admin.contestant.selfie.reject')}}",
	            data: {contestant_id: rid, season: season}
	        }).done(function (data) {
	            $(".show-hide-data").hide();
	            $(".show-hide-selfie").show();
	            jQuery('.list_selfie').html(data);
	        }).fail(function () {
	            alert('Articles could not be loaded.');
	        });
	    }

	    function onClickDeleteS3(rid, season) {
	    	jQuery.ajax({
	            url : "{{route('contestants.admin.contestant.selfie.delete')}}",
	            data: {contestant_id: rid, season: season}
	        }).done(function (data) {
	            swal("Videos successfully deleted from AWS S3");
	        }).fail(function () {
	            alert('Articles could not be loaded.');
	        });
	    }

	    function onClickCancel() {
	    	getArticlesNew();
	    }

	    function onClickResult(rid, season, result) {
	    	jQuery.ajax({
	            url : "{{route('contestants.admin.contestant.selfie.result')}}",
	            data: {contestant_id: rid, season: season, result: result}
	        }).done(function (data) {
	            getArticlesNew();
	        }).fail(function () {
	            alert('Articles could not be loaded.');
	        });
	    }

	    function getArticlesNew() {
	    	$("video").each(function () { this.pause() });
	    	
	    	var url = jQuery(this).attr('href');

	    	jQuery.ajax({
                url : url
            }).done(function (data) {
                jQuery('.list_data').html(data);
                $(".show-hide-data").show();
	        	$(".show-hide-selfie").hide();
            }).fail(function () {
                alert('Articles could not be loaded.');
            });
	    }

	    function onClickAddFeedback(rid, season) {
	    	event.preventDefault();
	    	$(".error-msg").text("");

	    	var custom_feedback = $("#custom_feedback").val();
		    var custom_feedback_check = $("#custom_feedback_check").prop("checked");

	    	if(custom_feedback == '' || custom_feedback_check == false){
		    	$(".error-msg").text("* Enter and check feedback.");
		    	return false;
		    }
		    else{
			    jQuery.ajax({
	                url : "{{ route('contestants.admin.contestant.selfie.feedback.store') }}",
	                data: { contestant_id: rid, season: season, custom_feedback: custom_feedback }
	            }).done(function (data) {
	                if(data == 1){
	                	$('#feedback-Modal').modal('hide');

	                	jQuery.ajax({
				            url : "{{route('contestants.admin.contestant.selfie.reject')}}",
				            data: {contestant_id: rid, season: season}
				        }).done(function (data) {
				            jQuery('.list_selfie').html(data);
				            $('#feedback-Modal').modal('show');
				        }).fail(function () {
				            alert('Someting wents wrong. Try again!');
				        });

	                	swal("Feedback added to list successfully");

	                	$("#custom_feedback").val('');

		                var cbarray = document.getElementsByName('feedback');
						for(var i = 0; i < cbarray.length; i++){
						    cbarray[i].checked = false
						}

						var cbarr = document.getElementsByName('custom_feedback_check');
						for(var i = 0; i < cbarr.length; i++){
						    cbarr[i].checked = false
						}
	                }
	                else{
	                	swal("Someting wents wrong. Try again!");
	                }
	            }).fail(function () {
	                alert('Someting wents wrong. Try again!');
	            });
		    }
	    }

	    function onClickSubmitFeedback(rid, season) {
	    	event.preventDefault();
	    	$(".error-msg").text("");

		    var feedbackIDs = $('input[name="feedback"]:checked').map(function(){
		      return $(this).val();
		    }).get();

		    var custom_feedback = $("#custom_feedback").val();
		    var custom_feedback_check = $("#custom_feedback_check").prop("checked");

		    if(feedbackIDs.length == 0 && custom_feedback == ''){
		    	$(".error-msg").text("* Select or enter any feedback.");
		    	return false;
		    }

		    if(custom_feedback_check){
		    	var data = { contestant_id: rid, season: season, feedback_id: feedbackIDs, custom_feedback: custom_feedback, custom_feedback_check: 1 }
		    }
		    else{
		    	var data = { contestant_id: rid, season: season, feedback_id: feedbackIDs, custom_feedback: custom_feedback, custom_feedback_check: 0 }
		    }

		    jQuery.ajax({
                url : "{{ route('contestants.admin.contestant.selfie.feedback') }}",
                data: data
            }).done(function (data) {
                if(data == 1){
                	swal("Feedback submitted successfully");

                	$('#feedback-Modal').modal('hide');

                	jQuery.ajax({
			            url : "{{route('contestants.admin.contestant.selfie.reject')}}",
			            data: {contestant_id: rid, season: season}
			        }).done(function (data) {
			            jQuery('.list_selfie').html(data);
			            $('#feedback-Modal').modal('show');
			        }).fail(function () {
			            alert('Someting wents wrong. Try again!');
			        });
                }
                else{
                	alert('Someting wents wrong. Try again!');
                }
            }).fail(function () {
                alert('Someting wents wrong. Try again!');
            });
	    }

	    function onClickUpdateFeedback(rid, season) {
	    	event.preventDefault();
	    	$(".error-msg").text("");

		    var feedbackIDs = $('input[name="feedback"]:checked').map(function(){
		      return $(this).val();
		    }).get();

		    var custom_feedback = $("#custom_feedback").val();
		    var custom_feedback_check = $("#custom_feedback_check").prop("checked");

		    if(feedbackIDs.length == 0 && custom_feedback == ''){
		    	$(".error-msg").text("* Select or enter any feedback.");
		    	return false;
		    }

		    if(custom_feedback_check){
		    	var data = { contestant_id: rid, season: season, feedback_id: feedbackIDs, custom_feedback: custom_feedback, custom_feedback_check: 1 }
		    }
		    else{
		    	var data = { contestant_id: rid, season: season, feedback_id: feedbackIDs, custom_feedback: custom_feedback, custom_feedback_check: 0 }
		    }

		    jQuery.ajax({
                url : "{{ route('contestants.admin.contestant.selfie.feedback') }}",
                data: data
            }).done(function (data) {
                if(data == 2){
                	swal("Feedback updated successfully");

                	$('#feedback-Modal').modal('hide');

                	jQuery.ajax({
			            url : "{{route('contestants.admin.contestant.selfie.reject')}}",
			            data: {contestant_id: rid, season: season}
			        }).done(function (data) {
			            jQuery('.list_selfie').html(data);
			            $('#feedback-Modal').modal('show');
			        }).fail(function () {
			            alert('Someting wents wrong. Try again!');
			        });
                }
                else{
                	swal("Someting wents wrong. Try again!");
                }
                
            }).fail(function () {
                alert('Someting wents wrong. Try again!');
            });
	    }
    </script>
    <script type="text/javascript">
    	$(document).ready(function(){
    		$(".onClickShowHide").on('click', function() {
    			$(".export-data-count").text("XXX");
    			$(".show-hide-export").toggle();
    		})

    		$(".onClickGetDataCount").on('click', function() {
    			var category = $(".category").val();
    			var from_date = $(".from_date").val();
    			var to_date = $(".to_date").val();

    			$.ajax({
                    url : "{{ route('admin.payments.export.count') }}",
                    data: {category: category, from_date: from_date, to_date: to_date}
                }).done(function (data) {
                    // console.log(data);
                    $(".export-data-count").text(data);
                }).fail(function () {
                    alert('Someting wents wrong.');
                });
    		})
    	})
    </script>
@endsection