@extends('contestant-admin.layouts.app')

@section('style')
<style type="text/css">
	.btn-sm{
		margin: 0 10px;
	}
</style>
@endsection

@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Selies List</h5>
							<span>Selies Management</span>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="page-header-breadcrumb">
						<ul class=" breadcrumb breadcrumb-title">
							<li class="breadcrumb-item"></li>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-data">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-6">
												<input type="text" name="search" placeholder="Search by name, email, phone ..." class="form-control keyword" onkeyup="return getSearchArticles(this.value);"><br>
											</div>
										</div>
										<div class="dt-responsive table-responsive list_data">
											@include('contestant-admin.result.pending.ajax-list')
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

@endsection

@section('script')
	<script type="text/javascript">
        jQuery(function() {
        	$('#from-date').dateDropper({
			  format: 'Y-m-d',
			  large: true
			});

			$('#to-date').dateDropper({
			  format: 'Y-m-d'
			});

            jQuery('body').on('click', '.pagination a', function(e) {
				
                e.preventDefault();

                jQuery('#load a').css('color', '#dfecf6');
                // jQuery('#load').append('<img style="position: absolute; left: 0; top: 0; z-index: 100000;" src="images/loader.gif" />');

                var url = jQuery(this).attr('href');

                // check if search filed non empty
                var keyword = $(".keyword").val();

                if(keyword == ''){
                	getArticles(url);
                }
                else{
                	getArticlesWithKeyword(url, keyword);
                }
                
                // window.history.pushState("", "", url);
            });

            function getArticles(url) {
                jQuery.ajax({
                    url : url
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }

            function getArticlesWithKeyword(url, keyword) {
                jQuery.ajax({
                    url : url,
                    data: {search:keyword}
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }
        });

		function getSearchArticles(keyword) {
			var url = window.location.href;
			jQuery.ajax({
				url : url,
				data: {search:keyword}
			}).done(function (data) {
				jQuery('.list_data').html(data);
			}).fail(function () {
				alert('Articles could not be loaded.');
			});
		}

		function getSearchArticlesByStatus(status) {
			var url = window.location.href;
			jQuery.ajax({
				url : url,
				data: {status:status}
			}).done(function (data) {
				jQuery('.list_data').html(data);
			}).fail(function () {
				alert('Articles could not be loaded.');
			});
		}
    </script>
@endsection