<table class="table table-striped table-bordered nowrap">
	<thead>
		<tr>
			<th></th>
			<th></th>
		</tr>
	</thead>
	<tbody>
		<tr>
			@php $i = 1; @endphp
			@forelse ($lists as $list)
				<td class="text-center">
					<video width="320" height="240" controls>
						<source src="{{ $list->link }}" type="video/mp4">
						Your browser does not support the video tag.
					</video>
				</td>
			@php $i++; @endphp
			@empty
				<td colspan="2" class="text-center">No data available in table</td>
			@endforelse
		</tr>
		@if(isset($contestant_id) && isset($season))
		<tr>
			<td colspan="2" class="text-center">
				<button class="btn btn-danger btn-sm waves-effect waves-light" onclick="onClickResult('{{$contestant_id}}', '{{$season}}', 0)" data-toggle="tooltip" data-placement="top" title="Move to Contestant List">Move to Contestant List</button>
				<button class="btn btn-primary btn-sm waves-effect waves-light" onclick="onClickResult('{{$contestant_id}}', '{{$season}}', 2)" data-toggle="tooltip" data-placement="top" title="Average">Average</button>
				<button class="btn btn-danger btn-sm waves-effect waves-light" onclick="onClickResult('{{$contestant_id}}', '{{$season}}', 3)" data-toggle="tooltip" data-placement="top" title="Reject">Reject</button>
				<button class="btn btn-warning btn-sm waves-effect waves-light" onclick="onClickCancel()" data-toggle="tooltip" data-placement="top" title="Back">Back</button>
				<button type="button" class="btn btn-info btn-sm waves-effect waves-light md-trigger" data-toggle="modal" data-target="#feedback-Modal">Feedback</button>
			</td>
		</tr>
		@endif
	</tbody>
</table>
@if(isset($feedbacks) && isset($contestant_id) && isset($season))
	<div class="modal fade" id="feedback-Modal" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Feeback</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					@forelse($feedbacks as $feedback)
						<input type="checkbox" name="feedback" value="{{ $feedback->id }}" 
							@if($checkFeedbackCount > 0)
								@if(in_array($feedback->id, json_decode($checkFeedback->feedback_id))) checked @endif
							@endif
						>&nbsp; {{ $feedback->text }}<br>
					@empty
					@endforelse
					<br>
					@if($checkFeedbackCount == 0)
					<div class="form-group row">
						<div class="col-sm-8">
							<label class="col-form-label"><b>Custom Feedback :</b></label>
							<textarea type="text" class="form-control" id="custom_feedback" name="custom_feedback" placeholder="Enter feedback" autocomplete="off"></textarea>
						</div>
					</div>
					<input type="checkbox" id="custom_feedback_check" name="custom_feedback_check" value="0">&nbsp; Do you want to save custom feedback in feedback list.
					@else
						<div class="form-group row">
							<div class="col-sm-8">
								<label class="col-form-label"><b>Custom Feedback :</b></label>
								<textarea type="text" class="form-control" id="custom_feedback" name="custom_feedback" placeholder="Enter feedback" autocomplete="off">{{$checkFeedback->custom_feedback}}</textarea>
							</div>
						</div>
					@endif
					<br>
				</div>
				<span class="error-msg" style="color: red;margin: 0px 15px;"></span><br>
				<div class="modal-footer">
					<button type="button" class="btn btn-default waves-effect " data-dismiss="modal">Close</button>
					@if($checkFeedbackCount == 0)
						<button type="button" class="btn btn-primary waves-effect waves-light" onclick="onClickAddFeedback('{{$contestant_id}}', '{{$season}}')">Add to Feedback list</button>
						<button type="button" class="btn btn-primary waves-effect waves-light" onclick="onClickSubmitFeedback('{{$contestant_id}}', '{{$season}}')">Submit Feedback</button>
					@else
						<button type="button" class="btn btn-primary waves-effect waves-light" onclick="onClickUpdateFeedback('{{$contestant_id}}', '{{$season}}')">Update Feedback</button>
					@endif
				</div>
			</div>
		</div>
	</div>
@endif