@extends('contestant-admin.layouts.app')
@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Feedback List</h5>
							<span>Feedback Management</span>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="page-header-breadcrumb">
						<ul class=" breadcrumb breadcrumb-title">
							<li class="breadcrumb-item">
								<a href="{{ route('contestants.admin.feedback.create') }}" class="btn btn-primary btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Add"><i class="icon-plus"></i> Add</a>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="dt-responsive table-responsive">
											<table id="multi-colum-dt" class="table table-striped table-bordered nowrap">
												<thead>
													<tr>
														<th>#</th>
														<th>Text</th>
														<th>Action</th>
													</tr>
												</thead>
												<tbody>
													@php $i = 1; @endphp
													@forelse ($lists as $list)
														<tr>
															<td>{{ $i }}</td>
															<td>{{ $list->text }}</td>
															<td>
																<div class="btn-group" role="group" style="width: 95px;">
																	<a href="{{ route('contestants.admin.feedback.edit', [$list->id]) }}" class="btn btn-success btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Edit"><i class="icon-pencil"></i></a>
																	
																	<form action="{{ route('contestants.admin.feedback.destroy', [$list->id]) }}" method="POST" id="delete-from-{{$list->id}}">
																		@method('DELETE')
																		@csrf
																		
																		<button type="button" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Delete" onclick="onClickDelete('{{$list->id}}')"><i class="icon-trash"></i></button>
																	</form>
																</div>
															</td>
														</tr>
														@php $i++; @endphp
													@empty
														<tr>
															<td colspan="3" class="text-center">No data available in table</td>
														</tr>
													@endforelse
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

	<script type="text/javascript">
		function onClickDelete(id) {
			swal("Are you sure? want to delete.", {
				buttons: {
					yes: {
						text: "Yes",
						value: "yes",
					},
					no: {
						text: "No",
						value: "no",
					}
				},
			})
			.then((value) => {
			  switch (value) {
			    case "yes":
			      $('#delete-from-'+id).get(0).submit();
			      break;
			 
			    case "no":
			      break;
			 
			    default:
			      swal("Got away safely!");
			  }
			});
		}
	</script>

@endsection