@extends('contestant-admin.layouts.app')
@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Edit Feedback</h5>
							<span>Feedback Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-3"></div>
											<div class="col-sm-6">
												<form action="{{ route('contestants.admin.feedback.update', [$data->id]) }}" method="POST">
													@method('PUT')
													@csrf
													
													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Message :</label>
															<textarea class="form-control" id="text" rows="3" name="text" placeholder="Write something here..." autocomplete="off">{{ $data->text }}</textarea>

															@error('text')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Update">Update</button>

															<a href="{{ route('contestants.admin.feedback.list') }}" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Cancel" style="color: #fff;">Cancel</a>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

@endsection