@extends('layouts.app')

@section('content')

    <section class="login-block">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <form method="POST" action="{{ route('contestants.login.check') }}">
                        @csrf
                        <div class="text-center">
                            <!-- <img class="img-fluid" src="{{url('backend/files/assets/images/logo.png')}}" alt="Theme-Logo" /> -->
                            <h3 class="text-center">Talentriangle Contestant Admin</h3>
                        </div>
                        <div class="auth-box card">
                            <div class="card-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h3 class="text-center"><i class="icofont icofont-lock text-primary f-80"></i></h3>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <div class="col-sm-10" style="margin: auto;">
                                        <label class="col-form-label">Email :</label>
                                        <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">
                                        @error('email')
                                            <span class="messages"><p class="text-danger error">{{ $message }}</p></span>
                                            <span class="messages popover-valid">
                                                <i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="col-sm-10" style="margin: auto;">
                                        <label class="col-form-label">Password :</label>
                                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" value="{{ old('password') }}" required autocomplete="password">
                                        @error('password')
                                            <span class="messages"><p class="text-danger error">{{ $message }}</p></span>
                                            <span class="messages popover-valid">
                                                <i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <div class="col-md-6 offset-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>

                                            <label class="form-check-label" for="remember">
                                                {{ __('Remember Me') }}
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-10" style="margin: auto;">
                                        <button type="submit" class="btn btn-primary btn-md btn-block waves-effect text-center m-b-20">
                                            <i class="icofont icofont-lock"></i> {{ __('Login') }} 
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

@endsection
