<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="no-js">
  <head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=0">
    <title>{{ config('app.name', 'Registration') }}</title>

    <link rel="icon" href="{{url('favicon.ico')}}" type="image/x-icon">

    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="">

    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,700&amp;subset=cyrillic" rel="stylesheet">
    <link href="{{url('frontend/font-awesome/4.7.0/css/font-awesome.min.css')}}" rel="stylesheet">
    <link href="{{url('frontend/shared.css')}}" rel="stylesheet">
    <link href="{{url('frontend/select2-krajee.min.css')}}" rel="stylesheet">
    <link href="{{url('frontend/kv-widgets.min.css')}}" rel="stylesheet">
    <link href="{{url('frontend/intlTelInput.css')}}" rel="stylesheet">
    <link href="{{url('frontend/site.css')}}" rel="stylesheet">
    <link href="{{url('frontend/panel.css')}}" rel="stylesheet">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/js/bootstrap-select.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/css/bootstrap-select.min.css" rel="stylesheet" />

    <style type="text/css">
      .btn-default {
        color: #555 !important;
        background-color: #fff;
        border-color: rgba(0,0,0,0.15);
      }

      .btn-default:hover, .btn-default:focus, .btn-default.focus, .btn-default:active, .btn-default.active, .open>.btn-default.dropdown-toggle {
        color: #555 !important;
        background-color: #fff;
        border-color: rgba(0,0,0,0.15);
      }

      .btn .caret {
        border-top-color: #555;
      }

      .bootstrap-select .dropdown-toggle:focus {
        outline: 0px auto -webkit-focus-ring-color!important;
      }

      .bottom-link {
        margin: 22px;
      }

      @media only screen and (max-width: 600px) {
        .bottom-link {
          margin: 15px;
        }
      }
    </style>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-179511125-1"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'UA-179511125-1');
    </script>
  </head>
  <body class="outside">
  	<div id="w1"></div>
  	<div class="cnt-center" style="background-image: url('image/background.jpg'); background-repeat: no-repeat; background-position: center; background-size: cover">
      <div class="single-widget-container registration">
        <section class="widget registration-widget">
		  		@yield('content')
		  	</section>
      </div>
    </div>

  	<script src="{{url('frontend/kv-widgets.min.js')}}"></script>
    <script src="{{url('frontend/utils.js')}}"></script>
    <script src="{{url('frontend/intlTelInput-jquery.js')}}"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

  	@yield('script')
  </body>
</html>