@extends('audition.layouts.app')

@section('style')
	<link href="https://vjs.zencdn.net/7.8.4/video-js.css" rel="stylesheet" />
	<script src="https://vjs.zencdn.net/ie8/1.1.2/videojs-ie8.min.js"></script>
	<style>
        .progress { position:relative; width:100%; }
        .bar { background-color: #008000; width:0%; height:20px; }
        .percent { position:absolute; display:inline-block; left:50%; color: #7F98B2;}

        .bs-stepper-circle{
  			background: dodgerblue;
		    padding: 6px 11px;
		    border-radius: 50%;
		    color: #fff;
  		}

  		video {
		    width: inherit !important;
		    max-width: 320px;
		}

		.video-js {
		    width: inherit !important;
		    max-width: 320px;
		}
   	</style>
@endsection

@section('content')

	<div class="pcoded-content">
		@php $i = 0; @endphp
		@forelse ($getRegistrations as $getRegistration)
			<div class="page-header card hide category-{{$getRegistration->id}}" @if($i > 0) style="display: none;" @endif>
				<div class="row align-items-end">
					<div class="col-sm-9">
						<div class="page-header-title">
							<i class="bg-c-blue icon-list"></i>
							<div class="d-inline">
								<h5>Online Audition</h5>
								<span>{{ucfirst($getRegistration->category)}} Category</span>
							</div>
							<!-- <div class="row">
								<div class="col-sm-1">
									<img src="{{url('image/singing.png')}}" style="width: 50px;">
								</div>
								<div class="col-sm-11">
									<div class="d-inline">
										<h5>Online Audition</h5>
										@if(count($getRegistrations) == 1)
											<span>{{ucfirst($getRegistration->category)}} Category</span>
										@endif
									</div>
								</div>
							</div> -->
						</div>
						<br>
					</div>
					<div class="col-sm-3">
						@if(count($getRegistrations) > 1)
							<select class="js-example-basic-single col-sm-12 category-select" name="category" id="category" style="width: 100%">
								@forelse($getRegistrations as $category)
									<option value="{{$category->id}}"
										@if($getRegistration->id == $category->id)
											selected
										@endif
									>{{ucfirst($category->category)}} Category</option>
								@empty
								@endforelse
							</select>
						@endif
					</div>
				</div>
			</div>

			<div class="pcoded-inner-content hide category-{{$getRegistration->id}}" @if($i > 0) style="display: none;" @endif>
				<div class="main-body">
					<div class="page-wrapper">
						<div class="page-body">
							<div class="row">
								<div class="col"></div>
								<div class="col-sm-8">
									<div class="row">
										@if($getRegistration->getSelfie && count($getRegistrations) > 1)
											<div class="col-sm-12">
												<div class="card">
													<div class="card-block">
														<div class="row">
															<div class="col-sm-12" style="text-align: center;">
																<!-- <video
																	id="my-video-{{$getRegistration->id}}"
																	class="video-js"
																	controls
																	preload="auto"
																	width="320"
																	height="240"
																	poster="{{url('image/logo.jpg')}}"
																	data-setup="{}"
																	style="margin: auto;"
																>
																	<source src="{{ $getRegistration->getSelfie->link }}" />
																	<p class="vjs-no-js">
																		To view this video please enable JavaScript, and consider upgrading to a
																		web browser that
																		<a href="https://videojs.com/html5-video-support/" target="_blank">supports HTML5 video</a
																	>
																	</p>
																</video> -->

																<video controls poster="{{url('image/logo.jpg')}}" width="320" height="240">
																  <source src="{{ $getRegistration->getSelfie->link }}" />
																  Your browser does not support the video tag.
																</video>
																
																@if($getRegistration->getSelfie->is_selfie_submitted == 0)
																	<br>
																	<a href="{{ route('audition.selfie.remove', [$getRegistration->getSelfie->id]) }}" class="btn btn-danger">Remove Video</a>
																@endif
															</div>
														</div>
													</div>
												</div>
											</div>
										@endif

										@if($getRegistration->getSelfie)
											@if($getRegistration->getSelfie->is_selfie_submitted == 0 && $getRegistration->getSelfie->result == 0)
												<div class="col-sm-12">
													<div class="card">
														<div class="card-block">
															<div class="row">
																<div class="col-sm-12">
																	<form action="{{ route('audition.selfie.submit') }}" method="POST" enctype="multipart/form-data">
																		@csrf

																		<input type="hidden" name="audition_id" value="{{ $getRegistration->getSelfie->id }}">

																		<div class="form-group row upload-self">
																			<div class="col-sm-12">
																				<label class="col-form-label" style="font-weight: 700;">Submit Your Audition Video :</label>
																				<br><br>

																				<span class="messages">
																					<p class="error">
																						This is the final step, please re-check your audition video once you will submit this video you will not be able to change it.
																					</p>
																				</span>
																			</div>
																		</div>

																		<div class="form-group row">
																			<div class="col-sm-12">
																				<span class="messages"><p class="text-danger error all-error"></p></span><br>
																				<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light submit-btn" data-toggle="tooltip" data-placement="bottom" title="Submit">Submit</button>
																			</div>
																		</div>
																	</form>
																</div>
															</div>
														</div>
													</div>
												</div>
											@else
												@if($getRegistration->getSelfie->result == 0)
													<div class="col-sm-12">
														<div class="card">
															<div class="card-block">
																<div class="row">
																	<div class="col-sm-12">
																		<div class="row">
																			<div class="col-sm-12">
																				<label class="col-form-label" style="font-weight: 700; text-align: center;">We have received your audition video your result will be declared in the next 24-48 hours.</label>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												@endif

												@if($getRegistration->getSelfie->result == 1)
													<div class="col-sm-12">
														<div class="card">
															<div class="card-block">
																<div class="row">
																	<div class="col-sm-12">
																		<div class="row">
																			<div class="col-sm-12">
																				<div class="col-form-label" style="font-weight: 600; text-align: center;">
																					Hi {{$getRegistration->name}},<br><br>
																					{!! nl2br($getRegistration->getSelfie->message) !!}
																					<hr>
																					@if(file_exists(storage_path('/file/'.$getRegistration->getSelfie->file_link)))
																						<label>This audio contain all information about this audition.</label>
																						<audio controls>
																							<source src="{{url('talentriangle/storage/file/'.$getRegistration->getSelfie->file_link)}}">
																							Your browser does not support the audio tag.
																						</audio>
																						<br/><hr>
																					@endif

																					<a href="{{ route('payment') }}" class="btn btn-sm btn-primary" target="_blank">Pay Now</a>

																					@if($getRegistration->getSelfie->prep_link != '')
																						<hr>
																						<a href="{{ $getRegistration->getSelfie->prep_link }}" class="btn btn-sm btn-primary" target="_blank">
																							@if($getRegistration->getSelfie->link_label != '')
																								{{ $getRegistration->getSelfie->link_label }}
																							@else
																								Click Here
																							@endif
																						</a><br/><br/>
																					@endif
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												@endif

												@if($getRegistration->getSelfie->result == 2)
													<div class="col-sm-12">
														<div class="card">
															<div class="card-block">
																<div class="row">
																	<div class="col-sm-12">
																		<div class="row">
																			<div class="col-sm-12">
																				<div class="col-form-label" style="font-weight: 600; text-align: center;">
																					Hi {{$getRegistration->name}},<br><br>
																					{!! nl2br($getRegistration->getSelfie->message) !!}
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												@endif

												@if($getRegistration->getSelfie->result == 3)
													<div class="col-sm-12">
														<div class="card">
															<div class="card-block">
																<div class="row">
																	<div class="col-sm-12">
																		<div class="row">
																			<div class="col-sm-12">
																				<div class="col-form-label" style="font-weight: 600; text-align: center;">
																					Hi {{$getRegistration->name}},<br><br>
																					{!! nl2br($getRegistration->getSelfie->message) !!}
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												@endif

												@if($getRegistration->getSelfie->result == 4)
													<div class="col-sm-12">
														<div class="card">
															<div class="card-block">
																<div class="row">
																	<div class="col-sm-12">
																		<div class="row">
																			<div class="col-sm-12">
																				<div class="col-form-label" style="font-weight: 600; text-align: center;">
																					Hi {{$getRegistration->name}},<br><br>
																					{!! nl2br($getRegistration->getSelfie->message) !!}
																					<hr>
																					@if(file_exists(storage_path('/file/'.$getRegistration->getSelfie->file_link)))
																						<label>This audio contain all information about this audition.</label>
																						<audio controls>
																							<source src="{{url('talentriangle/storage/file/'.$getRegistration->getSelfie->file_link)}}">
																							Your browser does not support the audio tag.
																						</audio>
																						<br/><hr>
																					@endif

																					<a href="{{ route('payment') }}" class="btn btn-sm btn-primary" target="_blank">Pay Now</a>

																					@if($getRegistration->getSelfie->prep_link != '')
																						<hr>
																						<a href="{{ $getRegistration->getSelfie->prep_link }}" class="btn btn-sm btn-primary" target="_blank">
																							@if($getRegistration->getSelfie->link_label != '')
																								{{ $getRegistration->getSelfie->link_label }}
																							@else
																								Click Here
																							@endif
																						</a><br/><br/>
																					@endif
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
														<div class="card">
															<div class="card-block">
																<div class="row">
																	<div class="col-sm-12">
																		<div class="row">
																			<div class="col-sm-12">
																				<div class="col-form-label" style="font-weight: 600; text-align: center;">
																					Hi {{$getRegistration->name}},<br><br>
																					{!! nl2br($getRegistration->getSelfie->last_message) !!}
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												@endif

												@if($getRegistration->getSelfie->result == 3 && $getRegistration->getSelfie->feedback != '')
													<div class="col-sm-12">
														<div class="card">
															<div class="card-block">
																<div class="row">
																	<div class="col-sm-12">
																		<div class="row">
																			<div class="col-sm-12">
																				<div class="col-form-label" style="font-weight: 600; text-align: center;">
																					Feedback<br><br>
																					{!! nl2br($getRegistration->getSelfie->feedback) !!}
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												@endif
											@endif
										@else
											<div class="col-sm-12">
												<div class="card">
													<div class="card-block">
														<div class="row">
															<div class="col-sm-12">
																<form id="upload-selfie-{{$getRegistration->id}}" action="{{ route('audition.selfie.upload') }}" method="POST" enctype="multipart/form-data">
																		@csrf

																		<input type="hidden" name="id" value="{{ $getRegistration->id }}">

																		<div class="form-group row upload-self" style="text-align: center;">
																			<div class="col-sm-12">
																				<label class="col-form-label" style="font-weight: 700;">How to upload your audition video?</label><br>
																				<video
																					id="demo-sample"
																					class="video-js"
																					controls
																					preload="auto"
																					width="320"
																					data-setup="{}"
																					style="margin: auto;"
																				>
																					<source src="{{ url('image/demo-sample.mp4') }}" />
																					<p class="vjs-no-js">
																						To view this video please enable JavaScript
																					</p>
																				</video>
																				<hr>
																			</div>

																			<div class="col-sm-8">
																				<label class="col-form-label" style="font-weight: 700;">Upload Your Audition Video (Duration 1-2 min) :</label>
																				<br><br>

																				<input type="file" class="form-control" id="file-{{$getRegistration->id}}" name="file" required accept=".mp4, .mp3, .m4a, .mpeg|audio/*|video/*"><br>
																				<div class="progress progress-{{$getRegistration->id}}" style="display: none;">
															                        <div class="bar bar-{{$getRegistration->id}}"></div >
															                        <div class="percent percent-{{$getRegistration->id}}">0%</div >
															                    </div>
																			</div>
																			<div class="col-sm-8 show-hide-loader-{{$getRegistration->id}}" style="display: none;">
																				<img src="{{ url('image/loader.gif') }}" style="width: 100%">
															                    <div class="text-center">Please wait...</div>
																			</div>
																		</div>

																		<div class="form-group row">
																			<div class="col-sm-12">
																				<span class="messages"><p class="text-danger error all-error-{{$getRegistration->id}}"></p></span><br>
																				<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light submit-btn-{{$getRegistration->id}}" data-toggle="tooltip" data-placement="bottom" title="Upload">Upload</button>
																			</div>
																		</div>

																</form>
															</div>
														</div>
													</div>
												</div>
											</div>
										@endif
									</div>
								</div>
								<div class="col"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
			@php $i++; @endphp
		@empty
		@endforelse
	</div>

@endsection

@section('script')
	<script src="https://vjs.zencdn.net/7.8.4/video.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.form/4.2.2/jquery.form.js"></script>

	@forelse ($getRegistrations as $getRegistration)
		<script type="text/javascript">
		    $(function() {
		        $(document).ready(function(){
		            var bar = $('.bar-{{$getRegistration->id}}');
		            var percent = $('.percent-{{$getRegistration->id}}');

					$('#upload-selfie-{{$getRegistration->id}}').ajaxForm({
						beforeSend: function() {
							var allExt = ['mp4', 'mp3', 'm4a', 'mpeg', 'mov']
					 		var fileName = $('#file-{{$getRegistration->id}}').val();

					 		var splitFile = fileName.split(".")
						 	var findLength = splitFile.length;
						 	var ext = splitFile[findLength -1];

					 		if(allExt.includes(ext)){
					 			$(".all-error-{{$getRegistration->id}}").text('');
								$('.progress-{{$getRegistration->id}}').show();
								$('.submit-btn-{{$getRegistration->id}}').attr('disabled', 'disabled');
							    var percentVal = '0%';
							    bar.width(percentVal)
							    percent.html(percentVal);
					 		}
					 		else{
					 			$(".all-error-{{$getRegistration->id}}").text('* Not a valid file accepted files are (.mp4, .mp3, .m4a, .mpeg)');
					 			xhr.abort();
					 		}
							
						},
						uploadProgress: function(event, position, total, percentComplete) {
						    var percentVal = percentComplete + '%';
						    console.log(percentVal);
						    bar.width(percentVal)
						    percent.html(percentVal);
						    if(percentComplete == 100){
						    	$('.progress-{{$getRegistration->id}}').hide();
						    	$('.show-hide-loader-{{$getRegistration->id}}').show();
						    }
						},
						complete: function(xhr) {
							if(xhr.status == 200){
								console.log(xhr);
								window.location.reload();
							}
							else{
								var errorSize = Object.values(xhr.responseJSON.errors).length;
								
								$('.progress-{{$getRegistration->id}}').hide();
								$('.submit-btn-{{$getRegistration->id}}').removeAttr('disabled', 'disabled');
							    var percentVal = '0%';
							    bar.width(percentVal)
							    percent.html(percentVal);

								$(".all-error-{{$getRegistration->id}}").text('* ' + Object.values(xhr.responseJSON.errors)[0]);
							}
						}
					});
		   		}); 
		 	});
		</script>

	@empty
	@endforelse

	<script type="text/javascript">
		$(document).ready(function(){
			$(".category-select").on('change', function(){
				var id = $(this).val();
				
				$(".hide").hide();
				$(".category-"+id).show();
			})
		})
	</script>

	@error('response')
		<script type="text/javascript">
			$(document).ready(function(){
				swal('{{$message}}');
			});
		</script>
	@enderror

@endsection