@extends('audition.layouts.app')

@section('content')

	<div class="pcoded-content">
		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-2"></div>
							<div class="col-sm-8">
								<div class="card">
									<div class="card-block">
										<h4 class="text-center">Before submitting your selfie video you have to fill this form.</h4>
										<hr>
										<div class="row">
											<div class="col-sm-2"></div>
											<div class="col-sm-8">
												<form action="{{ route('audition.form.submit') }}" method="POST" enctype="multipart/form-data">
													@csrf

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Name :</label>
															<input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" placeholder="Enter name" autocomplete="off" required>

															@error('name')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Email :</label>
															<input type="text" class="form-control" id="email" name="email" value="{{ old('email') }}" placeholder="Enter email" autocomplete="off" required>

															@error('email')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Talent Category :</label>
															<select class="js-example-basic-single col-sm-12" name="category" id="category">
																<option value="" selected disabled>Choose your category</option>
																@forelse($categories as $category)
																	<option value="{{ $category->name }}"
																		@if(old('category') == $category->name)
																			selected
																		@endif
																	>{{ $category->name }}</option>
																@empty
																@endforelse
															</select>

															@error('category')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Gender :</label>
															<select class="js-example-basic-single col-sm-12" name="gender" id="gender">
																<option value="" selected disabled>Select gender</option>
																<option value="male"
																	@if(old('gender') == 'male')
																		selected
																	@endif
																>Male</option>
																<option value="female"
																	@if(old('gender') == 'female')
																		selected
																	@endif
																>Female</option>
																<option value="other"
																	@if(old('gender') == 'other')
																		selected
																	@endif
																>Other</option>
															</select>

															@error('gender')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Age Group :</label>
															<select class="js-example-basic-single col-sm-12" name="age_group" id="age_group">
																<option value="" selected disabled>Select age group</option>
																<option value="junior"
																	@if(old('age_group') == 'junior')
																		selected
																	@endif
																>Junior (5 to 15)</option>
																<option value="senior"
																	@if(old('age_group') == 'senior')
																		selected
																	@endif
																>Senior (16 to 45)</option>
															</select>

															@error('age_group')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">State :</label>
															<select class="js-example-basic-single col-sm-12" name="state" id="select-state">
																<option selected disabled>Select your state</option>
																@forelse ($states as $state)
												                    <option value="{{$state->code}}">{{$state->name}}</option>
												                @empty
												                @endforelse
															</select>

															@error('state')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">City :</label>
															<select class="js-example-basic-single col-sm-12" name="city" id="select-city">
																<option selected disabled>Select your state first</option>
															</select>

															@error('city')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Submit">Submit</button>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

@endsection

@section('script')
  <script>
    function hideError(){
      $(".errorText").text('');
    }
  </script>

  <script type="text/javascript">
    (function($) {
      $.fn.inputFilter = function(inputFilter) {
        return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function() {
          if (inputFilter(this.value)) {
            this.oldValue = this.value;
            this.oldSelectionStart = this.selectionStart;
            this.oldSelectionEnd = this.selectionEnd;
          } else if (this.hasOwnProperty("oldValue")) {
            this.value = this.oldValue;
            this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
          } else {
            this.value = "";
          }
        });
      };
    }(jQuery));

    $("#phone").inputFilter(function(value) {
    return /^\d*$/.test(value) && (value === "" || parseInt(value) <= 9999999999); });
  </script>

  <script type="text/javascript">
    $(document).ready(function(){
      $("#select-state").on('change', function(){
        var state_code = $(this).val();
        var CSRF_TOKEN = "{{ csrf_token() }}";

        $.ajax({
          url: "{{route('getCities')}}",
          type: "POST",
          data:{_token: CSRF_TOKEN, state_code: state_code},
          success:function(data){
            var options = [];
            var src = data;

            src.forEach(function (item) {
              var option = "<option value='"+ item.slug +"'>" + item.name + "</option>"
              options.push(option);
            });
            $('#select-city').html('<option value="" selected disabled>Select your city</option>'+options);
          }
        });
      })

      $(".onClickSubmit").on('click', function(){
        var name = $("#name").val();
        if(name == ''){
          $(".errorText").text('* Name field is empty.');
          return false;
        }

        var email = $("#email").val();
        if(email == ''){
          $(".errorText").text('* Email field is empty.');
          return false;
        }
        else{
          var emailRegex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
          if(!emailRegex.test(email)){
            $(".errorText").text('* Email not valid.');
            return false;
          }
        }

        var phone = $("#phone").val();
        if(phone == ''){
          $(".errorText").text('* Phone field is empty.');
          return false;
        }

        var phone = $("#phone").val();
        if(phone.length < 10){
          $(".errorText").text('* Enter a valid phone number.');
          return false;
        }

        var category = $("#category").val();
        if(category == ''){
          $(".errorText").text('* Talent category field is empty.');
          return false;
        }

        var gender = $("#gender").val();
        if(gender == ''){
          $(".errorText").text('* Gender field is empty.');
          return false;
        }

        var age_group = $("#age-group").val();
        if(age_group == ''){
          $(".errorText").text('* Age group field is empty.');
          return false;
        }

        var select_state = $("#select-state").val();
        if(select_state == ''){
          $(".errorText").text('* State field is empty.');
          return false;
        }

        var select_city = $("#select-city").val();
        if(select_city == ''){
          $(".errorText").text('* City field is empty.');
          return false;
        }

        var CSRF_TOKEN = "{{ csrf_token() }}";

        $(this).attr('disabled');

        $.ajax({
          url: "{{route('checkRegistration')}}",
          type: "POST",
          data:{_token: CSRF_TOKEN,
          	name: name,
          	email: email,
          	phone: phone,
          	category: category,
          	gender: gender,
            age_group: age_group,
            state: select_state,
            city: select_city,
          },
          success:function(data){
            if(data == 0){
              $('#submit_form').get(0).submit();
            }
            else{
              swal("Oops!", "Someone is already registered with these details.");
            }
          },
          error: function(data){
            $(".errorText").text('* '+data.responseJSON.errors);
          }
        })
        
      });
    });
  </script>
@endsection