@extends('audition.layouts.app')

@section('style')

	<style>
        .progress { position:relative; width:100%; }
        .bar { background-color: #008000; width:0%; height:20px; }
        .percent { position:absolute; display:inline-block; left:50%; color: #7F98B2;}

        .bs-stepper-circle{
  			background: dodgerblue;
		    padding: 6px 11px;
		    border-radius: 50%;
		    color: #fff;
  		}
   	</style>

@endsection

@section('content')

	<div class="pcoded-content">
		@php $i = 0; @endphp
		@forelse ($getRegistrations as $getRegistration)
			<div class="page-header card hide category-{{$getRegistration->id}}" @if($i > 0) style="display: none;" @endif>
				<div class="row align-items-end">
					<div class="col-sm-9">
						<div class="page-header-title">
							<i class="bg-c-blue icon-list"></i>
							<div class="d-inline">
								<h5>Online Audition</h5>
								@if(count($getRegistrations) == 1)
									<span>{{ucfirst($getRegistration->category)}} Category</span>
								@endif
							</div>
						</div>
						<br>
					</div>
					<div class="col-sm-3">
						@if(count($getRegistrations) > 1)
							<select class="js-example-basic-single col-sm-12 category-select" name="category" id="category" style="width: 100%">
								@forelse($getRegistrations as $category)
									<option value="{{$category->id}}"
										@if($getRegistration->id == $category->id)
											selected
										@endif
									>{{ucfirst($category->category)}} Category</option>
								@empty
								@endforelse
							</select>
						@endif
					</div>
				</div>
			</div>

			<div class="pcoded-inner-content hide category-{{$getRegistration->id}}" @if($i > 0) style="display: none;" @endif>
				<div class="main-body">
					<div class="page-wrapper">
						<div class="page-body">
							<div class="row">
								<div class="col"></div>
								<div class="col-sm-6">
									<div class="card">
										<div class="card-block text-left">
											<h5>Name: <small>{{ $getRegistration->name }}</small></h5><br>
											<h5>Phone: <small>{{ $getRegistration->phone }}</small></h5><br>
											<h5>Email: <small>{{ $getRegistration->email }}</small></h5><br>
											<h5>Category: <small>{{ $getRegistration->category }}</small></h5><br>
											<h5>Gender: <small>{{ ucfirst($getRegistration->gender) }}</small></h5><br>
											<h5>Age Group: <small>{{ ucfirst($getRegistration->age_group) }}</small></h5>
										</div>
									</div>
								</div>
								<div class="col"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
			@php $i++; @endphp
		@empty
		@endforelse
	</div>

@endsection

@section('script')

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.form/4.2.2/jquery.form.js"></script>

	@forelse ($getRegistrations as $getRegistration)
		<script type="text/javascript">
		    $(function() {
		        $(document).ready(function(){
		            var bar = $('.bar-{{$getRegistration->id}}');
		            var percent = $('.percent-{{$getRegistration->id}}');

					$('#upload-selfie-{{$getRegistration->id}}').ajaxForm({
						beforeSend: function() {
							var allExt = ['mp4', 'mp3', 'm4a', 'mpeg']
					 		var fileName = $('#file-{{$getRegistration->id}}').val();

					 		var splitFile = fileName.split(".")
						 	var findLength = splitFile.length;
						 	var ext = splitFile[findLength -1];

					 		if(allExt.includes(ext)){
					 			$(".all-error-{{$getRegistration->id}}").text('');
								$('.progress-{{$getRegistration->id}}').show();
								$('.submit-btn-{{$getRegistration->id}}').attr('disabled', 'disabled');
							    var percentVal = '0%';
							    bar.width(percentVal)
							    percent.html(percentVal);
					 		}
					 		else{
					 			$(".all-error-{{$getRegistration->id}}").text('* Not a valid file accepted files are (.mp4, .mp3, .m4a, .mpeg)');
					 			xhr.abort();
					 		}
							
						},
						uploadProgress: function(event, position, total, percentComplete) {
						    var percentVal = percentComplete + '%';
						    console.log(percentVal);
						    bar.width(percentVal)
						    percent.html(percentVal);
						},
						complete: function(xhr) {
							if(xhr.status == 200){
								console.log(xhr);
								window.location.reload();
							}
							else{
								var errorSize = Object.values(xhr.responseJSON.errors).length;
								
								$('.progress-{{$getRegistration->id}}').hide();
								$('.submit-btn-{{$getRegistration->id}}').removeAttr('disabled', 'disabled');
							    var percentVal = '0%';
							    bar.width(percentVal)
							    percent.html(percentVal);

								$(".all-error-{{$getRegistration->id}}").text('* ' + Object.values(xhr.responseJSON.errors)[0]);
							}
						}
					});
		   		}); 
		 	});
		</script>

	@empty
	@endforelse

	<script type="text/javascript">
		$(document).ready(function(){
			$(".category-select").on('change', function(){
				var id = $(this).val();
				
				$(".hide").hide();
				$(".category-"+id).show();
			})
		})
	</script>

@endsection