@extends('layouts.app1')

@section('content')

    <section class="login-block">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <form method="POST" action="{{ route('audition.login.check') }}">
                        @csrf
                        <div class="text-center"><br>
                            <img class="img-fluid" src="{{url('image/logo.png')}}" alt="Theme-Logo" width="150" />
                            <!-- <h3 class="text-center">Talentriangle Audition</h3> -->
                        </div>
                        <div class="auth-box card">
                            <div class="card-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h3 class="text-center">
                                            Welcome to Talent Triangle<br>(Online Auditions)
                                        </h3>
                                    </div>
                                </div>
                                <hr>

                                <div class="form-group row">
                                    <div class="col-sm-10" style="margin: auto;">
                                        <label class="col-form-label">Mobile :</label>
                                        <input id="phone" type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}" required autocomplete="phone" placeholder="Enter your mobile number">
                                        @error('phone')
                                            <span class="messages"><p class="text-danger error">{{ $message }}</p></span>
                                            <span class="messages popover-valid">
                                                <i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-10" style="margin: auto;">
                                        <button type="submit" class="btn btn-primary btn-md btn-block waves-effect text-center m-b-20">
                                            <i class="icofont icofont-lock"></i> {{ __('Login') }} 
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('script')
    <script type="text/javascript">
        (function($) {
          $.fn.inputFilter = function(inputFilter) {
            return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function() {
              if (inputFilter(this.value)) {
                this.oldValue = this.value;
                this.oldSelectionStart = this.selectionStart;
                this.oldSelectionEnd = this.selectionEnd;
              } else if (this.hasOwnProperty("oldValue")) {
                this.value = this.oldValue;
                this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
              } else {
                this.value = "";
              }
            });
          };
        }(jQuery));

        $("#phone").inputFilter(function(value) {
          return /^\d*$/.test(value) && (value === "" || parseInt(value) <= 9999999999);
        });
    </script>
@endsection