@extends('audition-admin.layouts.app')
@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Edit Message</h5>
							<span>Message Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-3"></div>
											<div class="col-sm-6">
												<form action="{{ route('auditions.admin.message.update', [$data->id]) }}" method="POST" enctype="multipart/form-data">
													@method('PUT')
													@csrf
													
													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Message :</label>
															<h4>Hi xyx,</h4>
															<textarea class="form-control" id="message" rows="3" name="message" placeholder="Write message here..." autocomplete="off">{{ $data->message }}</textarea>

															@error('message')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													@if($data->type == 1)
														<div class="form-group row show-hide">
															<div class="col-sm-12">
																<label class="col-form-label">Link Label:</label>
																<input type="text" class="form-control" id="link_label" name="link_label" value="{{$data->link_label}}" placeholder="Enter link label">
															</div>
														</div>

														<div class="form-group row show-hide">
															<div class="col-sm-12">
																<label class="col-form-label">Link :</label>
																<input type="text" class="form-control" id="link" name="link" value="{{$data->link}}" placeholder="Enter link">
															</div>
														</div>

														<audio controls>
															  <source src="{{url('talentriangle/storage/file/'.$data->file)}}">
															  Your browser does not support the audio tag.
														</audio>

														<div class="form-group row show-hide">
															<div class="col-sm-12">
																<label class="col-form-label">Upload New Audio File :</label>
																<input type="file" class="form-control" id="file" name="file" accept="audio/*">
															</div>
														</div>

														<div class="form-group row show-hide">
															<div class="col-sm-12">
																<label class="col-form-label">Last Date Message :</label>
																<textarea class="form-control" id="last_message" rows="3" name="last_message" placeholder="Write message here..." autocomplete="off">{{$data->last_message}}</textarea>
															</div>
														</div>
													@endif

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Update">Update</button>

															<a href="{{ route('auditions.admin.message.index') }}" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Cancel" style="color: #fff;">Cancel</a>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

@endsection

@section('script')
	<script>
        ClassicEditor
            .create( document.querySelector( '#message' ) )
            .catch( error => {
                console.error( error );
            } );

        ClassicEditor
            .create( document.querySelector( '#last_message' ) )
            .catch( error => {
                console.error( error );
            } );
    </script>
@endsection