<table class="table table-striped table-bordered nowrap">
	<thead>
		<tr>
			<th></th>
		</tr>
	</thead>
	<tbody>
		<tr>
			@php $i = 1; @endphp
			@forelse ($lists as $list)
				<td class="text-center">
					<video width="320" height="240" controls>
						<source src="{{ $list->link }}" type="video/mp4">
						Your browser does not support the video tag.
					</video>
				</td>
			@php $i++; @endphp
			@empty
				<td colspan="2" class="text-center">No data available in table</td>
			@endforelse
		</tr>
		@if(isset($registration_id))
		<tr>
			<td colspan="2" class="text-center">
				<button type="button" class="btn btn-success btn-sm waves-effect waves-light md-trigger" onclick="onClickResult('{{$registration_id}}', 1)" data-toggle="tooltip" data-placement="top" title="Accept">Accept</button>&emsp;

				<button type="button" class="btn btn-primary btn-sm waves-effect waves-light md-trigger" onclick="onClickResult('{{$registration_id}}', 2)" data-toggle="tooltip" data-placement="top" title="Reject">Reject</button>&emsp;

				<button type="button" class="btn btn-info btn-sm waves-effect waves-light md-trigger" data-toggle="modal" data-target="#Re-Invite-Modal">Re-Invite</button>&emsp;

				<button type="button" class="btn btn-success btn-sm waves-effect waves-light md-trigger" onclick="onClickBest('{{$registration_id}}')" data-toggle="tooltip" data-placement="top" title="Mark as Best">Mark as Best</button>&emsp;

				<button type="button" class="btn btn-secondary btn-sm waves-effect waves-light md-trigger" data-toggle="modal" data-target="#change-category-Modal">Change Category</button>&emsp;

				<button class="btn btn-warning btn-sm waves-effect waves-light" onclick="onClickCancel()" data-toggle="tooltip" data-placement="top" title="Back">Back</button>
			</td>
		</tr>
		@endif
	</tbody>
</table>

@if(isset($messages) && isset($registration) && isset($registration_id))
	<div class="modal fade" id="Re-Invite-Modal" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Re-Invite</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="form-group row">
						<div class="col-sm-12">
							<label class="col-form-label">Feedback(if any) :</label>
							<textarea class="form-control" id="message_re_invite" rows="5" name="message_re_invite" placeholder="Write message here..." autocomplete="off"></textarea>
						</div>
					</div>
				</div>
				<span class="error-msg" style="color: red;margin: 0px 15px;"></span><br>
				<div class="modal-footer">
					<button type="button" class="btn btn-default waves-effect " data-dismiss="modal">Close</button>
					<button class="btn btn-success waves-effect waves-light" onclick="onClickResult('{{$registration_id}}', 3)" data-toggle="tooltip" data-placement="top" title="Submit">Submit</button>
				</div>
			</div>
		</div>
	</div>
@endif

@if(isset($registration_id))
	@php
		$categories = App\Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();
	@endphp
	<div class="modal fade" id="change-category-Modal" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Change Category</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="form-group row">
						<div class="col-sm-12">
							<label class="col-form-label">Category :</label>
							<select class="js-example-basic-single col-sm-12" name="change_category" id="change_category">
								<option disabled selected>Choose Category</option>
								@forelse($categories as $category)
									<option value="{{ $category->name }}">{{ $category->name }}</option>
								@empty
								@endforelse
							</select>
						</div>
					</div>
				</div>
				<span class="error-msg-cat" style="color: red;margin: 0px 15px;"></span><br>
				<div class="modal-footer">
					<button type="button" class="btn btn-default waves-effect " data-dismiss="modal">Close</button>
					<button class="btn btn-success waves-effect waves-light" onclick="onClickChangeCategory('{{$registration_id}}')" data-toggle="tooltip" data-placement="top" title="Submit">Submit</button>
				</div>
			</div>
		</div>
	</div>
@endif