<table class="table table-striped table-bordered nowrap">
	<thead>
		<tr>
			<th>#</th>
			<th>Date</th>
			<th>Name</th>
			<th>Email/Phone/Gender</th>
			<th>Category</th>
			<th>Result</th>
			<th>Action</th>
		</tr>
	</thead>
	<tbody>
		@php $i = 1; @endphp
		@forelse ($lists as $list)
			<tr>
				<td>{{ $i }}</td>
				<td>{{ Carbon\Carbon::parse($list->getSelfie->updated_at)->format('d-M-Y, h:i A') }}</td>
				<td>{{ $list->name }}</td>
				<td>
					<i class="icon-envelope"></i> {{ $list->email }} <br>
					<i class="icon-phone"></i> {{ $list->phone }} <br>
					@if($list->gender == 'female')
						<i class="icon-symbol-female"></i> {{ ucfirst($list->gender) }}
					@else
						<i class="icon-symbol-male"></i> {{ ucfirst($list->gender) }}
					@endif
				</td>
				<td>{{ ucfirst($list->category) }}</td>
				<td>
					@if($list->getSelfie->result == 0)
						Not Declared
					@endif

					@if($list->getSelfie->result == 1 || $list->getSelfie->result == 4)
						Selected
					@endif

					@if($list->getSelfie->result == 2)
						Rejected
					@endif

					@if($list->getSelfie->result == 3)
						Re-Invited
					@endif
				</td>
				<td>
					@if($list->getSelfie->is_selfie_submitted == 0 && $list->getSelfie->result == 0)
					@else
						<div class="btn-group" role="group" style="width: 215px">
							<button class="btn btn-primary btn-sm-new waves-effect waves-light" onclick="onClickPlay('{{$list->getSelfie->registration_id}}')" data-toggle="tooltip" data-placement="top" title="Play Videos"><i class="icon-social-youtube"></i></button>

							<a href="{{route('auditions.admin.audition.edit', [$list->id])}}" class="btn btn-success btn-sm-new waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Edit Details"><i class="icon-pencil"></i></a>

							@if($list->getSelfie->is_best == 0)
								<button class="btn btn-danger btn-sm-new waves-effect waves-light" onclick="onClickDeleteAuditionVideo('{{$list->getSelfie->registration_id}}', '{{$list->season}}')" data-toggle="tooltip" data-placement="top" title="Delete Video"><i class="icon-trash"></i></button>
							@endif

							<button class="btn btn-info btn-sm-new waves-effect waves-light" onclick="onClickSendSMS('{{$list->getSelfie->registration_id}}', 5)" data-toggle="tooltip" data-placement="top" title="Send SMS"><i class="icon-speech"></i></button>

							<a href="https://wa.me/91{{ $list->phone }}?text=Hi {{ $list->name }}, " class="btn btn-warning btn-sm-new waves-effect waves-light" target="_blank" data-toggle="tooltip" data-placement="top" title="Send on WhatsApp" style="padding: 8.5px;">
								<i class="fa fa-whatsapp"></i>
							</a>
						</div>
					@endif
				</td>
			</tr>
			@php $i++; @endphp
		@empty
			<tr>
				<td colspan="7" class="text-center">No data available in table</td>
			</tr>
		@endforelse
		<tr>
			<td colspan="13" class="text-center">{{$lists->links()}}</td>
		</tr>
	</tbody>
</table>