@extends('audition-admin.layouts.app')
@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Edit Registration</h5>
							<span>Registrations Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-3"></div>
											<div class="col-sm-6">
												<form action="{{ route('auditions.admin.audition.update', [$data->id]) }}" method="POST">
													@method('PUT')
													@csrf
													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Name :</label>
															<input type="text" class="form-control" id="name" name="name" value="{{ $data->name }}" placeholder="Enter Name" autocomplete="off">

															@error('name')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Email :</label>
															<input type="text" class="form-control" id="email" name="email" value="{{ $data->email }}" placeholder="Enter Email" autocomplete="off">

															@error('email')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Phone :</label>
															<input type="text" class="form-control" id="phone" name="phone" value="{{ $data->phone }}" placeholder="Enter Phone" autocomplete="off">

															@error('phone')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Category :</label>
															<select class="js-example-basic-single col-sm-12" name="category" id="category">
																<option disabled selected>Select Category</option>
																@forelse($categories as $category)
																	<option value="{{ $category->name }}" 
																		@if($category->name == $data->category)
																			selected
																		@endif
																	>{{ $category->name }}</option>
																@empty
																@endforelse
															</select>

															@error('category')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Age Group :</label>
															<select class="js-example-basic-single col-sm-12" name="age_group" id="age_group">
																<option disabled selected>Select Age Group</option>
																<option value="junior" @if($data->age_group == 'junior') selected @endif>Junior (5 to 15)</option>
																<option value="senior" @if($data->age_group == 'senior') selected @endif>Senior (16 to 45)</option>
															</select>

															@error('age_group')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Update">Update</button>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

@endsection