<table class="table table-striped table-bordered nowrap">
	<thead>
		<tr>
			<th>#</th>
			<th>Date</th>
			<th>Name</th>
			<th>Email/Phone/Gender</th>
			<th>Category</th>
			<th>Result</th>
			<th>Action</th>
		</tr>
	</thead>
	<tbody>
		@php $i = 1; @endphp
		@forelse ($lists as $list)
			<tr>
				<td>{{ $i }}</td>
				<td>{{ Carbon\Carbon::parse($list->getSelfie->updated_at)->format('d-M-Y, h:i A') }}</td>
				<td>{{ $list->name }}</td>
				<td>
					<i class="icon-envelope"></i> {{ $list->email }} <br>
					<i class="icon-phone"></i> {{ $list->phone }} <br>
					@if($list->gender == 'female')
						<i class="icon-symbol-female"></i> {{ ucfirst($list->gender) }}
					@else
						<i class="icon-symbol-male"></i> {{ ucfirst($list->gender) }}
					@endif
				</td>
				<td>{{ ucfirst($list->category) }}</td>
				<td>
					@if($list->getSelfie->result == 0)
						Not Declared
					@endif

					@if($list->getSelfie->result == 1 || $list->getSelfie->result == 4)
						Selected
					@endif

					@if($list->getSelfie->result == 2)
						Rejected
					@endif

					@if($list->getSelfie->result == 3)
						Re-Invited
					@endif
				</td>
				<td>
					@if($list->getSelfie->is_selfie_submitted == 0 && $list->getSelfie->result == 0)
					@else
						<button class="btn btn-primary btn-sm waves-effect waves-light" onclick="onClickPlay('{{$list->getSelfie->registration_id}}')" data-toggle="tooltip" data-placement="top" title="Play Videos">Play Videos</button><br><br>

						<a href="{{route('auditions.admin.audition.edit', [$list->id])}}" class="btn btn-success btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Edit Details">Edit Details</a><br><br>
						@if($list->getSelfie->is_best == 0)
							<button class="btn btn-danger btn-sm waves-effect waves-light" onclick="onClickDeleteAuditionVideo('{{$list->getSelfie->registration_id}}', '{{$list->season}}')" data-toggle="tooltip" data-placement="top" title="Delete Video">Delete Video</button>
						@endif
					@endif
				</td>
			</tr>
			@php $i++; @endphp
		@empty
			<tr>
				<td colspan="7" class="text-center">No data available in table</td>
			</tr>
		@endforelse
		<tr>
			<td colspan="13" class="text-center">{{$lists->links()}}</td>
		</tr>
	</tbody>
</table>