@extends('admin.layouts.app')

@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>My Profile</h5>
							<span>Setting Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-3"></div>
											<div class="col-sm-6">
												<form action="{{ route('admin.settings.store') }}" method="POST">
													@csrf

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Username :</label>
															<input type="text" class="form-control" id="name" name="name" value="{{ Auth::user()->name }}" placeholder="Enter Name" autocomplete="off">

															@error('name')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>

														<div class="col-sm-12">
															<label class="col-form-label">Email :</label>
															<input type="text" class="form-control" id="email" name="email" value="{{ Auth::user()->email }}" placeholder="Enter Email" autocomplete="off">

															@error('email')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>

														<div class="col-sm-12">
															<label class="col-form-label">Password :</label>
															<input type="password" class="form-control" id="password" name="password" value="" placeholder="Enter New Password" autocomplete="new-password" readonly onfocus="this.removeAttribute('readonly');">

															@error('password')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Update">Update</button>

															<a href="{{ route('admin.home') }}" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Cancel" style="color: #fff;">Cancel</a>
														</div>
													</div>

												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Membership</h5>
							<span>Setting Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-3"></div>
											<div class="col-sm-6">
												<form action="{{ route('admin.settings.update', [Auth::user()->id]) }}" method="POST">
													@csrf
													@method('PUT')

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Show membership on payment page :</label><br>
															<div class="radio-inline">
																<label>
																	<input type="radio" name="membership" value="yes"  @if(Auth::user()->membership == 1) checked="checked" @endif>
																	<i class="helper"></i>Yes
																</label>&emsp;
																<label>
																	<input type="radio" name="membership" value="no"  @if(Auth::user()->membership == 0) checked="checked" @endif>
																	<i class="helper"></i>No
																</label>
															</div>
															@error('membership')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Update">Update</button>

															<a href="{{ route('admin.home') }}" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Cancel" style="color: #fff;">Cancel</a>
														</div>
													</div>

												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

@endsection