<table id="load" class="table table-striped table-bordered nowrap">
	<thead>
		<tr>
			<th>#</th>
			<th>Date</th>
			<th>Name</th>
			<th>Email/Phone/Gender</th>
			<th>Category</th>
			<th>City - State</th>
			<th>Season</th>
			<th>Platform</th>
			<th>Action</th>
		</tr>
	</thead>
	<tbody>
		@php $i = 1; @endphp
		@forelse ($lists as $list)
			<tr>
				<td>#{{ $list->id }}</td>
				<td>{{ Carbon\Carbon::parse($list->created_at)->format('d-M-Y, h:i A') }}</td>
				<td>{{ $list->name }}</td>
				<td>
					<i class="icon-envelope"></i> {{ $list->email }} <br>
					<i class="icon-phone"></i> {{ $list->phone }} <br>
					@if($list->gender == 'female')
						<i class="icon-symbol-female"></i> {{ ucfirst($list->gender) }}
					@else
						<i class="icon-symbol-male"></i> {{ ucfirst($list->gender) }}
					@endif
				</td>
				<td>{{ ucfirst($list->category) }} ({{ ucfirst($list->age_group) }})</td>
				<td>{{ $list->getCity->name }} - {{ $list->getState->name }}</td>
				<td>{{ $list->season }}</td>
				<td>{{ $list->platform }}</td>
				<td>
					<a href="{{ route('admin.registrations.edit', [$list->id]) }}" class="btn btn-success btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Edit"><i class="icon-pencil"></i></a>
					
					<form action="{{ route('admin.registrations.destroy', [$list->id]) }}" method="POST" id="delete-from-{{$list->id}}">
						@method('DELETE')
						@csrf
						
						<button type="button" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Delete" onclick="onClickDelete('{{$list->id}}')"><i class="icon-trash"></i></button>
					</form>
				</td>
			</tr>
			@php $i++; @endphp
		@empty
			<tr>
				<td colspan="13" class="text-center">No data available in table</td>
			</tr>
		@endforelse

		<tr>
			<td colspan="13" class="text-center">{{$lists->links()}}</td>
		</tr>
	</tbody>
</table>