<table class="table table-striped table-bordered nowrap">
	<thead>
		<tr>
			<th>#</th>
			<th>Date</th>
			<th>Registration ID</th>
			<th>Name</th>
			<th>Email/Phone/Gender</th>
			<th>Category</th>
			<th>City - State</th>
			<th>Payment Status</th>
			<th>Season</th>
			<th>OrderID</th>
			<th>Action</th>
		</tr>
	</thead>
	<tbody>
		@php $i = 1; @endphp
		@forelse ($lists as $list)
			<tr>
				<td>{{ $i }}</td>
				<td>{{ Carbon\Carbon::parse($list->payment_at)->format('d-M-Y, h:i A') }}</td>
				<td>{{ $list->registration_id }}</td>
				<td>{{ $list->name }}</td>
				<td>
					<i class="icon-envelope"></i> {{ $list->email }} <br>
					<i class="icon-phone"></i> {{ $list->phone }} <br>
					@if($list->gender == 'female')
						<i class="icon-symbol-female"></i> {{ ucfirst($list->gender) }}
					@else
						<i class="icon-symbol-male"></i> {{ ucfirst($list->gender) }}
					@endif
				</td>
				<td>{{ ucfirst($list->category) }} ({{ ucfirst($list->age_group) }})</td>
				<td>{{ $list->getCity->name }} - {{ $list->getState->name }}</td>
				<td>
					@if($list->status == 2)
						Success
					@else
						Pending
					@endif
				</td>
				<td>{{ $list->season }}</td>
				<td>{{ $list->order_id }}</td>
				<td>
					@if($list->status == 2)
						<button class="btn btn-primary btn-sm waves-effect waves-light" onclick="onClickSend('{{$list->id}}')" data-toggle="tooltip" data-placement="top" title="Send Message">Send Message</button><br>
					@endif

					<a href="{{ route('admin.payments.edit', [$list->id]) }}" class="btn btn-success btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Edit"><i class="icon-pencil"></i></a>
					
					<form action="{{ route('admin.payments.destroy', [$list->id]) }}" method="POST" id="delete-from-{{$list->id}}" class="btn waves-effect waves-light" style="padding: 5px;">
						@method('DELETE')
						@csrf
						
						<button type="button" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Delete" onclick="onClickDelete('{{$list->id}}')"><i class="icon-trash"></i></button>
					</form>
				</td>
			</tr>
			@php $i++; @endphp
		@empty
			<tr>
				<td colspan="13" class="text-center">No data available in table</td>
			</tr>
		@endforelse

		<tr>
			<td colspan="13" class="text-center">{{$lists->links()}}</td>
		</tr>
	</tbody>
</table>