@extends('admin.layouts.app')

@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Send Message</h5>
							<span>Message Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-1"></div>
											<div class="col-sm-5">
												@error('response')
													<div class="alert alert-success background-success">
														<button type="button" class="close" data-dismiss="alert" aria-label="Close">
														<i class="icofont icofont-close-line-circled text-white"></i>
														</button>
														<strong>{{$message}}!</strong>
													</div>
												@enderror
												

												<form action="{{ route('admin.message.send') }}" method="POST">
													@csrf

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Phone :</label>
															<input type="text" class="form-control" id="phone" name="phone" value="{{ old('phone') }}" placeholder="Enter phone" autocomplete="off" required>

															@error('phone')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>

														<div class="col-sm-12">
															<label class="col-form-label">Message :</label>
															<textarea class="form-control" id="message" rows="5" name="message" placeholder="Write something here." autocomplete="off" required>{{ old('message') }}</textarea>

															@error('message')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Send Message">Send Message</button>

															<a href="{{ route('admin.home') }}" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Cancel" style="color: #fff;">Cancel</a>
														</div>
													</div>

												</form>
											</div>
											<div class="col-sm-5" style="margin: auto;">
												<span class="messages">
													<p class="text-danger error">
														<b style="font-weight: 600">Note :</b><br>
														* For multiple numbers, use space to separate numbers.<br/>
														* Don't use other special characters.<br/>
														* Enter only 10 Digit number.<br/>
														* Don't use 0 , +91 or country code.<br/>
													</p>
												</span>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

@endsection