@extends('admin.layouts.app')
@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Add Mail</h5>
							<span>Mail Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-3"></div>
											<div class="col-sm-6">
												<form action="{{ route('admin.mail-setting.store') }}" method="POST">
													@csrf

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Email :</label>
															<input type="text" class="form-control" id="email" name="email" value="{{ old('email') }}" placeholder="Enter email" autocomplete="off">

															@error('email')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Password :</label>
															<input type="text" class="form-control" id="password" name="password" value="{{ old('password') }}" placeholder="Enter password" autocomplete="off">

															@error('password')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Status :</label><br>
															<div class="radio-inline">
																<label>
																	<input type="radio" name="status" value="yes" checked="checked">
																	<i class="helper"></i>Show
																</label>&emsp;
																<label>
																	<input type="radio" name="status" value="no">
																	<i class="helper"></i>Hide
																</label>
															</div>
															@error('status')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Add">Add</button>

															<a href="{{ route('admin.mail-setting.index') }}" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Cancel" style="color: #fff;">Cancel</a>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

@endsection