@extends('admin.layouts.app')

@section('style')
    <link rel="stylesheet" type="text/css" href="{{url('backend/files/assets/css/font-awesome-n.min.css')}}">
@endsection

@section('content')

    <div class="pcoded-content">
        <div class="page-header card">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <i class="icon-home bg-c-blue"></i>
                        <div class="d-inline">
                            <h5>Dashboard</h5>
                            <span>Talentriangle</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="page-header-breadcrumb">
                        <ul class=" breadcrumb breadcrumb-title">
                            <li class="breadcrumb-item">
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="pcoded-inner-content">
            <div class="main-body">
                <div class="page-wrapper">
                    <div class="page-body">
                        <div class="row">
                            <div class="col-xl-4 col-md-6">
                                <div class="card prod-p-card card-red">
                                    <div class="card-body">
                                        <div class="row align-items-center m-b-30">
                                            <div class="col">
                                                <h6 class="m-b-5 text-white">Total Categories</h6>
                                                <h3 class="m-b-0 f-w-700 text-white">{{$categories}}</h3>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-bars text-c-red f-18"></i>
                                            </div>
                                        </div>
                                        <p class="m-b-0 text-white">
                                            <a class="text-white" href="{{ route('admin.categories.index') }}">Manage Categories</a>
                                        </p>
                                    </div>
                                 </div>
                            </div>
                            <div class="col-xl-4 col-md-6">
                                <div class="card prod-p-card card-blue">
                                    <div class="card-body">
                                        <div class="row align-items-center m-b-30">
                                            <div class="col">
                                                <h6 class="m-b-5 text-white">Total Registrations</h6>
                                                <h3 class="m-b-0 f-w-700 text-white">{{$registrations}}</h3>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-bars text-c-blue f-18"></i>
                                            </div>
                                        </div>
                                        <p class="m-b-0 text-white">
                                            <a class="text-white" href="{{ route('admin.registrations.index') }}">Manage Registrations</a>
                                        </p>
                                    </div>
                                 </div>
                            </div>
                            <div class="col-xl-4 col-md-6">
                                <div class="card prod-p-card card-green">
                                    <div class="card-body">
                                        <div class="row align-items-center m-b-10">
                                            <div class="col">
                                                <h6 class="m-b-5 text-white">Paid Payments (Membership)</h6>
                                                <h3 class="m-b-0 f-w-700 text-white">{{$paidPaymentsMem}}</h3>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-bars text-c-green f-18"></i>
                                            </div>
                                        </div>
                                        <p class="m-b-0 text-white">
                                            <a class="text-white" href="{{ route('admin.payments.index') }}">Manage Payments</a>
                                        </p>
                                    </div>
                                 </div>
                            </div>
                            <div class="col-xl-4 col-md-6">
                                <div class="card prod-p-card card-yellow">
                                    <div class="card-body">
                                        <div class="row align-items-center m-b-10">
                                            <div class="col">
                                                <h6 class="m-b-5 text-white">Unpaid Payments (Membership)</h6>
                                                <h3 class="m-b-0 f-w-700 text-white">{{$unPaidPaymentsMem}}</h3>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-bars text-c-yellow f-18"></i>
                                            </div>
                                        </div>
                                        <p class="m-b-0 text-white">
                                            <a class="text-white" href="{{ route('admin.payments.index') }}">Manage Payments</a>
                                        </p>
                                    </div>
                                 </div>
                            </div>
                            <div class="col-xl-4 col-md-6">
                                <div class="card prod-p-card card-red">
                                    <div class="card-body">
                                        <div class="row align-items-center m-b-30">
                                            <div class="col">
                                                <h6 class="m-b-5 text-white">Paid Payments (Onetime)</h6>
                                                <h3 class="m-b-0 f-w-700 text-white">{{$paidPaymentsOne}}</h3>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-bars text-c-red f-18"></i>
                                            </div>
                                        </div>
                                        <p class="m-b-0 text-white">
                                            <a class="text-white" href="{{ route('admin.payments.index') }}">Manage Payments</a>
                                        </p>
                                    </div>
                                 </div>
                            </div>
                            <div class="col-xl-4 col-md-6">
                                <div class="card prod-p-card card-blue">
                                    <div class="card-body">
                                        <div class="row align-items-center m-b-30">
                                            <div class="col">
                                                <h6 class="m-b-5 text-white">Unpaid Payments (Onetime)</h6>
                                                <h3 class="m-b-0 f-w-700 text-white">{{$unPaidPaymentsOne}}</h3>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-bars text-c-blue f-18"></i>
                                            </div>
                                        </div>
                                        <p class="m-b-0 text-white">
                                            <a class="text-white" href="{{ route('admin.payments.index') }}">Manage Payments</a>
                                        </p>
                                    </div>
                                 </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-6 col-md-12">
                                <div class="card comp-card">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <h6 class="m-b-25">Today's Registrations</h6>
                                                <h3 class="f-w-700 text-c-blue">{{$todaysRegistrations}}</h3>
                                                <p class="m-b-0">{{$todaysDate->format('d-M, Y')}}</p>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-eye bg-c-blue"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <div class="card comp-card">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <h6 class="m-b-25">Today's Payments (Membership)</h6>
                                                <h3 class="f-w-700 text-c-green">{{$todaysPaidPaymentsMem}}</h3>
                                                <p class="m-b-0">{{$todaysDate->format('d-M, Y')}}</p>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-eye bg-c-green"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-md-12">
                                <div class="card comp-card">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <h6 class="m-b-25">Today's Payments (Onetime)</h6>
                                                <h3 class="f-w-700 text-c-green">{{$todaysPaidPaymentsOne}}</h3>
                                                <p class="m-b-0">{{$todaysDate->format('d-M, Y')}}</p>
                                            </div>
                                            <div class="col-auto">
                                                <i class="fas fa-eye bg-c-green"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection