<table class="table table-striped table-bordered nowrap">
	<thead>
		<tr>
			<th>#</th>
			<th>Submitted Date</th>
			<th>Registration ID</th>
			<th>Name</th>
			<th>Email/Phone/Gender</th>
			<th>Category</th>
			<th>City - State</th>
			<th>Payment Status</th>
			<th>Season</th>
		</tr>
	</thead>
	<tbody>
		@php $i = 1; @endphp
		@forelse ($lists as $list)
			<tr>
				<td>{{ $i }}</td>
				<td>{{ Carbon\Carbon::parse($list->updated_at)->format('d-M-Y, h:i A') }}</td>
				<td>{{ $list->registration_id }}</td>
				<td>{{ $list->name }}</td>
				<td>
					<i class="icon-envelope"></i> {{ $list->email }} <br>
					<i class="icon-phone"></i> {{ $list->phone }} <br>
					@if($list->gender == 'female')
						<i class="icon-symbol-female"></i> {{ ucfirst($list->gender) }}
					@else
						<i class="icon-symbol-male"></i> {{ ucfirst($list->gender) }}
					@endif
				</td>
				<td>{{ ucfirst($list->category) }} ({{ ucfirst($list->age_group) }})</td>
				<td>{{ $list->getCity->name }} - {{ $list->getState->name }}</td>
				<td>
					@if($list->status == 2)
						Success
					@else
						Pending
					@endif
				</td>
				<td>{{ $list->season }}</td>
			</tr>
			@php $i++; @endphp
		@empty
			<tr>
				<td colspan="13" class="text-center">No data available in table</td>
			</tr>
		@endforelse

		<tr>
			<td colspan="13" class="text-center">{{$lists->links()}}</td>
		</tr>
	</tbody>
</table>