@extends('admin.layouts.app')
@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Edit Category</h5>
							<span>Categories Management</span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="row">
											<div class="col-sm-3"></div>
											<div class="col-sm-6">
												<form action="{{ route('admin.categories.update', [$data->id]) }}" method="POST">
													@method('PUT')
													@csrf
													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Name :</label>
															<input type="text" class="form-control" id="name" name="name" value="{{ $data->name }}" placeholder="Enter Name" autocomplete="off">

															@error('name')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Message :</label>
															<input type="text" class="form-control" id="message" name="message" value="{{ $data->message }}" placeholder="Enter Message" autocomplete="off">

															@error('message')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Phone :</label>
															<input type="text" class="form-control" id="phone" name="phone" value="{{ $data->phone }}" placeholder="Enter Phone" autocomplete="off">

															@error('phone')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
																<span class="messages popover-valid">
																	<i class="text-danger error icofont icofont-close-circled" data-toggle="tooltip" data-placement="top" data-trigger="hover" title="" data-original-title="{{ $message }}" style="position: absolute; right: -10px; top: 38px;"></i>
																</span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Do you want invitation through WhatsApp link :</label><br>
															<div class="radio-inline">
																<label>
																	<input type="radio" name="whatsapp" value="yes" @if($data->whatsapp == 1) checked="checked" @endif>
																	<i class="helper"></i>Yes
																</label>&emsp;
																<label>
																	<input type="radio" name="whatsapp" value="no"  @if($data->whatsapp == 0) checked="checked" @endif>
																	<i class="helper"></i>No
																</label>
															</div>
															@error('whatsapp')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Show on registration page :</label><br>
															<div class="radio-inline">
																<label>
																	<input type="radio" name="status" value="yes"  @if($data->status == 1) checked="checked" @endif>
																	<i class="helper"></i>Yes
																</label>&emsp;
																<label>
																	<input type="radio" name="status" value="no"  @if($data->status == 0) checked="checked" @endif>
																	<i class="helper"></i>No
																</label>
															</div>
															@error('status')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<label class="col-form-label">Show on payment page :</label><br>
															<div class="radio-inline">
																<label>
																	<input type="radio" name="on_payment_page" value="yes"  @if($data->on_payment_page == 1) checked="checked" @endif>
																	<i class="helper"></i>Yes
																</label>&emsp;
																<label>
																	<input type="radio" name="on_payment_page" value="no"  @if($data->on_payment_page == 0) checked="checked" @endif>
																	<i class="helper"></i>No
																</label>
															</div>
															@error('on_payment_page')
																<span class="messages"><p class="text-danger error">{{ $message }}</p></span>
															@enderror
														</div>
													</div>

													<div class="form-group row">
														<div class="col-sm-12">
															<button type="submit" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Update">Update</button>

															<a href="{{ route('admin.categories.index') }}" class="btn btn-danger btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Cancel" style="color: #fff;">Cancel</a>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

@endsection