@extends('admin.layouts.app')

@section('style')
	<style type="text/css">
		.select2-container--default .select2-selection--single .select2-selection__arrow {
		    top: 3px;
		    right: 15px;
		}

		.select2-container--default .select2-selection--single .select2-selection__rendered {
		    background-color: #4099ff;
		    color: #fff;
		    padding: 0px 28px 0px 20px;
		}
	</style>
@endsection

@section('content')

	<div class="pcoded-content">

		<div class="page-header card">
			<div class="row align-items-end">
				<div class="col-lg-8">
					<div class="page-header-title">
						<i class="bg-c-blue icon-list"></i>
						<div class="d-inline">
							<h5>Audition List</h5>
							<span>Audition Management</span>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="page-header-breadcrumb">
						<ul class=" breadcrumb breadcrumb-title">
							<li class="breadcrumb-item">
								<!--  -->
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-last-message">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="text-left">
											<form id="export-form" action="{{ route('admin.audition.export') }}" method="POST">
			                                    @csrf
												<div class="row">
													<div class="col-sm-3">
														<span style="font-weight: 600">From Date:</span><br>
														<input type="date" name="from_date" id="from_date">
													</div>

													<div class="col-sm-3">
														<span style="font-weight: 600">To Date:</span><br>
														<input type="date" name="to_date" id="to_date">
													</div>

													<div class="col-sm-3">
														<span style="font-weight: 600">Select Category:</span><br>
														<select class="js-example-basic-single col-sm-12" name="category" id="category">
															<option disabled>Select Category</option>
															<option value="all">All</option>
															@forelse($categories as $category)
																<option value="{{ $category->name }}">{{ $category->name }}</option>
															@empty
															@endforelse
														</select>
													</div>

													<div class="col-sm-3">
														<span style="font-weight: 600">Select Result Type:</span><br>
														<select class="js-example-basic-single col-sm-12" name="result" id="result">
															<option disabled>Select Result Type</option>
															<option value="all">All</option>
															<option value="0">Not Declared</option>
															<option value="1">Selected</option>
															<option value="2">Rejected</option>
															<option value="3">Re-Invited</option>
															<option value="4">Last Message Sent</option>
														</select>
													</div>
												</div>
											</form><br>
											<button class="btn btn-sm btn-success" onclick="onClickSearch()">Search</button>
											<button class="btn btn-sm btn-secondary" onclick="onClickClear()">Clear</button>
											<a href="{{ route('admin.audition.export') }}" onclick="event.preventDefault(); document.getElementById('export-form').submit();" class="btn btn-primary btn-sm waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="Download Data">
												Download Data
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="pcoded-inner-content show-hide-data">
			<div class="main-body">
				<div class="page-wrapper">
					<div class="page-body">
						<div class="row">
							<div class="col-sm-12">
								<div class="card">
									<div class="card-block">
										<div class="dt-responsive table-responsive list_data">
											@include('admin.audition.ajax-list')
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
@endsection
@section('script')
	<script type="text/javascript">
        jQuery(function() {
        	$('#from-date').dateDropper({
			  format: 'Y-m-d',
			  large: true
			});

			$('#to-date').dateDropper({
			  format: 'Y-m-d'
			});

            jQuery('body').on('click', '.pagination a', function(e) {
				
                e.preventDefault();

                jQuery('#load a').css('color', '#dfecf6');
                // jQuery('#load').append('<img style="position: absolute; left: 0; top: 0; z-index: 100000;" src="images/loader.gif" />');

                var url = jQuery(this).attr('href');

            	var from_date = $("#from_date").val();
	        	var to_date = $("#to_date").val();
	        	var category = $("#category").val();
	        	var result = $("#result").val();

	        	getArticles(url, from_date, to_date, category, result);
                
                // window.history.pushState("", "", url);
            });

            function getArticles(url, from_date, to_date, category, result) {
                jQuery.ajax({
                    url : url,
                    data: {from_date: from_date, to_date: to_date, category: category, result: result}
                }).done(function (data) {
                    jQuery('.list_data').html(data);
                }).fail(function () {
                    alert('Articles could not be loaded.');
                });
            }
        });

        function onClickSearch() {
        	var from_date = $("#from_date").val();
        	var to_date = $("#to_date").val();
        	var category = $("#category").val();
        	var result = $("#result").val();

        	var url = "{{route('admin.audition.list')}}";
        	
        	jQuery.ajax({
                url : url,
                data: {from_date: from_date, to_date: to_date, category: category, result: result}
            }).done(function (data) {
                jQuery('.list_data').html(data);
            }).fail(function () {
                alert('Articles could not be loaded.');
            });
        }

        function onClickClear() {
        	var from_date = $("#from_date").val('');
        	var to_date = $("#to_date").val('');
        	var category = $("#category").val('all').trigger('change');
        	var result = $("#result").val('all').trigger('change');

        	var url = "{{route('admin.audition.list')}}";
        	
        	jQuery.ajax({
                url : url
            }).done(function (data) {
                jQuery('.list_data').html(data);
            }).fail(function () {
                alert('Articles could not be loaded.');
            });
        }
    </script>
@endsection