<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->check()) {
            // return redirect('/home');
            
            switch (Auth::user()->getRoleNames()[0]) {
                case 'admin':
                    return redirect()->route('admin.home');
                    break;
                default:
                    Auth::guard()->logout();

                    $request->session()->invalidate();

                    $request->session()->regenerateToken();

                    return redirect('/login');
            }
        }

        return $next($request);
    }
}
