<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Payment;
use App\State;
use App\City;
use App\Category;
use App\Season;
use App\User;
use App\Helpers\paytmHelper;
use Carbon\Carbon;
use Anand\LaravelPaytmWallet\Facades\PaytmWallet;
use App\Traits\SendMsg;
use Session;

class PaymentController extends Controller
{
    use SendMsg;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $states = State::get();
        $categories = Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();

        $admin = User::find(1);

        return view('payment', compact('states', 'categories', 'admin'));
    }

    public function registration(Request $request)
    {
        $this->validate(request(), [
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'category' => 'required',
            'gender' => 'required',
            'age_group' => 'required',
            'state' => 'required',
            'city' => 'required',
        ]);

        $name = $request->name;
        $email = $request->email;
        $phone = $request->phone;
        $category = $request->category;
        $gender = $request->gender;
        $age_group = $request->age_group;
        $state = $request->state;
        $city = $request->city;
        $membership = (isset($request->membership) && $request->membership == 0) ? 0 : 1;

        // get last season value
        $season = Season::orderBy('id', 'DESC')->first();

        if($membership == 0){
            $fee = 750;
        }
        else{
            $fee = 1500;
        }

        // Generate Order Id
        $order_id = $category."-ORD-".time();

        // check if user already applied for payment but payment did not completed
        $checkPayment = Payment::where('name', $name)
                            ->where('phone', $phone)
                            ->where('category', $category)
                            ->where('status', 0)
                            ->first();

        $count = Payment::where('name', $name)
                    ->where('phone', $phone)
                    ->where('category', $category)
                    ->where('status', 0)
                    ->count();

        if($checkPayment){
            $cust_id = $checkPayment->registration_id;

            // update order id
            $updateRegistration = Payment::find($checkPayment->id);
            $updateRegistration->email = $email;
            $updateRegistration->order_id = $order_id;
            $updateRegistration->gender = $gender;
            $updateRegistration->age_group = $age_group;
            $updateRegistration->state = $state;
            $updateRegistration->city = $city;
            $updateRegistration->membership = $membership;
            $updateRegistration->season = $season->name;
            $updateRegistration->fee = $fee;
            $updateRegistration->payment_at = Carbon::now();
            $updateRegistration->save();
        }
        else{
            if($count == 0){
                $registration = New Payment;
                $registration->name = $name;
                $registration->email = $email;
                $registration->phone = $phone;
                $registration->category = $category;
                $registration->gender = $gender;
                $registration->age_group = $age_group;
                $registration->state = $state;
                $registration->city = $city;
                $registration->membership = $membership;
                $registration->season = $season->name;
                $registration->fee = $fee;
                $registration->order_id = $order_id;
                $registration->payment_at = Carbon::now();
                $registration->created_at = Carbon::now();
                $registration->updated_at = Carbon::now();
                $registration->save();
            }

            // update registration id
            $update = Payment::find($registration->id);
            $update->registration_id = "TALENT".(20000 + $registration->id);
            $update->save();

            $cust_id = "TALENT".(20000 + $registration->id);
        }
        
        // return redirect()->to('https://www.instamojo.com/nexterapro/registration-fees-talentriangle-auditions-on/');

        $checkSum = "";
        $paramList = array();

        // Create an array having all required parameters for creating checksum.
        $paramList["MID"] = "NEXTER37749076656833";
        $paramList["ORDER_ID"] = $order_id;
        $paramList["CUST_ID"] = $cust_id;
        $paramList["INDUSTRY_TYPE_ID"] = "ECommerce";
        $paramList["CHANNEL_ID"] = "WEB";
        $paramList["TXN_AMOUNT"] = $fee;
        $paramList["WEBSITE"] = "DEFAULT";
        $paramList["CALLBACK_URL"] = url('paytm/payment/status');
        $paramList["MSISDN"] = $phone;
        $paramList["EMAIL"] = $email;

        $checkSum = getChecksumFromArray($paramList, "lRqMWS2qVeSek#bj");

        return view('pgRedirect')->with('paramList', $paramList)->with('checkSum', $checkSum);
    }

    public function paymentCallback()
    {
        header("Pragma: no-cache");
        header("Cache-Control: no-cache");
        header("Expires: 0");

        Session::forget('payment-message');
        Session::forget('payment-registration_id');

        $paytmChecksum = "";
        $paramList = array();
        $isValidChecksum = "FALSE";

        $paramList = $_POST;
        
        $paytmChecksum = isset($_POST["CHECKSUMHASH"]) ? $_POST["CHECKSUMHASH"] : "";

        $isValidChecksum = verifychecksum_e($paramList, "lRqMWS2qVeSek#bj", $paytmChecksum);
        if($isValidChecksum == "TRUE") {
            if ($_POST["STATUS"] == "TXN_SUCCESS") {
                
                // get payment id
                $getPayment = Payment::where('order_id', $_POST["ORDERID"])->first();

                // update payment
                $update = Payment::find($getPayment->id);
                $update->status = 2;
                $update->transaction_id = $_POST["TXNID"];
                $update->payment_at = Carbon::now();
                $update->save();

                $msg = $this->PaymentMsg($getPayment->phone, $getPayment->name, $getPayment->registration_id, $getPayment->membership);

                $message = "PAYMENT SUCCESSFULL";
                $registration_id = $getPayment->registration_id;

                Session::put('payment-message', $message);
                Session::put('payment-registration_id', $registration_id);
                Session::save();
            
                return redirect()->route('payment.status');
            }
            else {
                // get payment id
                $getPayment = Payment::where('order_id', $_POST["ORDERID"])->first();

                // update payment
                $update = Payment::find($getPayment->id);
                $update->payment_at = Carbon::now();
                $update->save();

                $message = "PAYMENT FAILED";

                Session::put('payment-message', $message);
                Session::save();
            
                return redirect()->route('payment.status');
            }
        }
        else {
            $message = "PAYMENT FAILED";
            
            Session::put('payment-message', $message);
            Session::save();

            return redirect()->route('payment.status');
        }
    }

    public function checkPaymentRegistration(Request $request)
    {
        $name = $request->name;
        $email = $request->email;
        $phone = $request->phone;
        $category = $request->category;
        $gender = $request->gender;
        $age_group = $request->age_group;
        $state = $request->state;
        $city = $request->city;

        // Setup the validator
        $rules = array(
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'category' => 'required',
            'gender' => 'required',
            'age_group' => 'required',
            'state' => 'required',
            'city' => 'required',
        );

        $validator = Validator::make($request->all(), $rules);

        // Validate the input and return correct response
        if ($validator->fails())
        {
            $errors = $validator->getMessageBag()->toArray();

            foreach ($errors as $error) {
                return \Response::json(array(
                    'success' => false,
                    'errors' => implode('', $error)
                ), 400);
            }
        }
        else{
            $count = Payment::where('name', $name)
                            ->where('phone', $phone)
                            ->where('category', $category)
                            ->where('status', 2)
                            ->count();

            return $count;
        }
    }

    public function paymentCallbackGetMethod(Request $request)
    {
        if(Session::has('payment-message') && Session::has('payment-registration_id')){
            $message = Session::get('payment-message');
            $registration_id = Session::get('payment-registration_id');

            return view('pgResponse', compact('message', 'registration_id'));
        }
        elseif(Session::has('payment-message')){
            $message = Session::get('payment-message');

            Session::forget('payment-message');
            Session::forget('payment-registration_id');

            return view('pgResponse', compact('message'));
        }
        else{
            Session::forget('payment-message');
            Session::forget('payment-registration_id');

            return redirect()->route('payment');
        }
    }
}
