<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Registration;
use App\State;
use App\City;
use App\Category;
use App\Season;
use Carbon\Carbon;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function index(Request $request)
    {
        $states = State::get();
        $cities = City::where('state_code', 'AN')->get();
        $categories = Category::where('status', 1)->orderBy('name', 'ASC')->get();

        return view('welcome', compact('states', 'cities', 'categories'));
    }

    public function seo(Request $request)
    {
        $states = State::get();
        $cities = City::where('state_code', 'AN')->get();
        $categories = Category::where('status', 1)->orderBy('name', 'ASC')->get();

        return view('seo', compact('states', 'cities', 'categories'));
    }

    public function getCities(Request $request)
    {
        $state_code = $request->state_code;
        $cities = City::where('state_code', $state_code)->get();

        return $cities;
    }

    public function registration(Request $request)
    {
        $this->validate(request(), [
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'category' => 'required',
            'gender' => 'required',
            'age_group' => 'required',
            'state' => 'required',
            'city' => 'required',
        ]);

        $name = $request->name;
        $email = $request->email;
        $phone = $request->phone;
        $category = $request->category;
        $gender = $request->gender;
        $age_group = $request->age_group;
        $state = $request->state;
        $city = $request->city;

        // get last season value
        $season = Season::orderBy('id', 'DESC')->first();

        $count = Registration::where('name', $name)
                            ->where('phone', $phone)
                            ->where('category', $category)
                            ->count();

        if($count == 0){
            $registration = New Registration;
            $registration->name = $name;
            $registration->email = $email;
            $registration->phone = $phone;
            $registration->category = $category;
            $registration->gender = $gender;
            $registration->age_group = $age_group;
            $registration->state = $state;
            $registration->city = $city;
            $registration->season = $season->name;

            if(isset($request->platform)){
                $registration->platform = 'SEO';
            }
            else{
                $registration->platform = 'Main';
            }

            $registration->created_at = Carbon::now();
            $registration->updated_at = Carbon::now();
            $registration->save();
        }

        // check for category
        $checkCategory = Category::where('name', $category)->first();
        if($checkCategory->whatsapp == 1 && $checkCategory->phone != ''){
            $url = "https://wa.me/91".$checkCategory->phone."?text=".$checkCategory->message;
            return redirect()->to($url);
        }
        else{
            return redirect()->action('HomeController@success', ['id' => $registration->id, 'category' => $category, 'message' => $checkCategory->message]);  
        }
    }

    public function success(Request $request)
    {
        $category = $request->category;
        $message = $request->message;
        return view('success', compact('category', 'message'));
    }

    public function checkRegistration(Request $request)
    {
        $name = $request->name;
        $email = $request->email;
        $phone = $request->phone;
        $category = $request->category;
        $gender = $request->gender;
        $age_group = $request->age_group;
        $state = $request->state;
        $city = $request->city;

        // Setup the validator
        $rules = array(
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'category' => 'required',
            'gender' => 'required',
            'age_group' => 'required',
            'state' => 'required',
            'city' => 'required',
        );

        $validator = Validator::make($request->all(), $rules);

        // Validate the input and return correct response
        if ($validator->fails())
        {
            $errors = $validator->getMessageBag()->toArray();

            foreach ($errors as $error) {
                return \Response::json(array(
                    'success' => false,
                    'errors' => implode('', $error)
                ), 400);
            }
        }
        else{
            $count = Registration::where('phone', $phone)
                            ->where('category', $category)
                            ->count();

            return $count;
        }
    }

    public function converter(Request $request)
    {
        // $ffmpeg = 'C:/ffmpeg/bin/ffmpeg.exe';
        $ffmpeg = '/home/talentri/ffmpeg-64-amd64-static/ffmpeg';
        $video = storage_path("app/public/videos/b44c0827b03d39db62b4bc916de6eb6c.flv");
        $fileName_new = time().'.mp4';
        $outpath = storage_path($fileName_new);

        // echo $video;

        $cmd = "$ffmpeg -i $video -b 250k -strict -2 $outpath";
        $return = `$cmd`;

        echo $return;
    }
}
