<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Redirect;
use App\Payment;
use App\Selfie;
use App\Season;
use Session;
use Illuminate\Support\Facades\Storage;

class ContestantController extends Controller
{
    public function contestant()
    {
    	return view('contestant.auth.login');
    }

    public function contestantLogin(Request $request)
    {
    	$this->validate(request(), [
            'phone' => 'required',
            'registration_id' => 'required',
        ]);

        $phone = $request->phone;
        $registration_id = $request->registration_id;

        $checkRegistration = Payment::where('phone', $phone)
    								->where('registration_id', $registration_id)
                                    ->where('status', 2)
    								->count();

        if($checkRegistration == 0){
        	return Redirect::back()->withErrors(['phone' => 'These credentials do not match our records.']);
        }
        else{
        	Session::put('registration', $registration_id);
        	return redirect()->route('contestant.dashboard');
        }
    }

    public function dashboard()
    {
    	if(Session::has('registration')){
    		$registration_id = Session::get('registration');

            // get payment detial
            $getPayment = Payment::where('registration_id', $registration_id)->first();

            $lists = Selfie::where('contestant_id', $registration_id)->get();

            // get result
            $results = Selfie::where('contestant_id', $registration_id)->select('contestant_id', 'result')->distinct('contestant_id')->with('getContestantFeedback')->first();

            // dd($results->getContestantFeedback['custom_feedback']);

    		return view('contestant.dashboard', compact('getPayment', 'lists', 'results'));
    	}
    	else{
    		return redirect()->route('contestant.login');
    	}
    }

    public function selfieUpload(Request $request)
    {
        if(Session::has('registration')){
            $registration_id = Session::get('registration');

            // get payment detial
            $getPayment = Payment::where('registration_id', $registration_id)->first();

            $path = Storage::disk('s3')->put($getPayment->phone.'/'.$registration_id, $request->file('file'));
            $request->merge([
                'size' => $request->file->getClientSize(),
                'path' => $path
            ]);

            // if($request->hasFile('file')){
            //     $image = $request->file('file');
            //     $ext = $request->file->getClientOriginalExtension();
            //     $file_name = md5(time()).'.'.$ext;
            //     $destinationPath = public_path('/videos');
            //     $image->move($destinationPath, $file_name);

            //     $file_link = public_path('/videos/'.$file_name);
            //     if(is_file($file_link)){
            //         unlink($file_link);
            //     }
            // }

            // get last season value
            $season = Season::orderBy('id', 'DESC')->first();

            // insert into database
            $insert = New Selfie;
            $insert->contestant_id = $registration_id;
            $insert->link = 'https://talentriangle.s3-ap-southeast-1.amazonaws.com/'.$path;
            $insert->season = $season->name;
            $insert->save();

            return 1;
        }
        else{
            return 0;
        }
    }

    public function selfieRemove(Request $request, $id)
    {
        $getFile = Selfie::find($id);

        // delete file from S3
        $q = Storage::disk('s3')->delete(str_replace('https://talentriangle.s3-ap-southeast-1.amazonaws.com/', '', $getFile->link));

        // delete file from db
        $destroy = Selfie::findOrFail($id);
        $destroy->delete();
        
        return back();
    }

    public function selfieSubmit($value='')
    {
        if(Session::has('registration')){
            $registration_id = Session::get('registration');

            // update payment detial
            $updatePayment = Payment::where('registration_id', $registration_id)->update(['is_selfie_submitted'=>1]);

            return redirect()->back();
        }
        else{
            Session::forget('registration');

            return redirect()->route('contestant.login');
        }
    }

    public function logout()
    {
        Session::forget('registration');

        return redirect()->route('contestant.login');
    }
}
