<?php

namespace App\Http\Controllers\Contestant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\ContestantAdmin;
use App\Season;
use App\Payment;
use App\Selfie;

class ResultController extends Controller
{
    public function bestList(Request $request)
    {
    	$sideBar = 'Best-List';

    	if(Session::has('contestant-admin')){
    		$email = Session::get('contestant-admin');

    		// get admin
    		$admin = ContestantAdmin::where('email', $email)->first();

            // get category
    		$category = $admin->getCategory->name;

    		// get current Season
    		$season = Season::orderBy('id', 'DESC')->first()->name;

            // get selfie ids
            $selfieIds = Selfie::where('result', 1)
                            ->where('season', $season)
                            ->distinct('contestant_id')
                            ->pluck('contestant_id')
                            ->toArray();

    		// get all contestant who submitted selfie videos for the current Season
    		$result = Payment::orderBy('updated_at', 'ASC')
                            ->where('is_selfie_submitted', 1)
                            ->where('category', $category)
                            ->whereIn('registration_id', $selfieIds);

    		if($request->search != ''){
	            $result->where(function ($query) use ($request) {
	                $query->where('name', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('email', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
	            });
	        }

    		$lists = $result->paginate(20);

	        if ($request->ajax()) {
	            return view('contestant-admin..result.best.ajax-list', ['lists' => $lists])->render();    
	        }

    		return view('contestant-admin.result.best.list', compact('sideBar', "admin", "lists"));
    	}
    	else{
    		return redirect()->route('contestants.login');
    	}
    }

    public function averageList(Request $request)
    {
    	$sideBar = 'Average-List';

    	if(Session::has('contestant-admin')){
    		$email = Session::get('contestant-admin');

    		// get category
    		$admin = ContestantAdmin::where('email', $email)->first();

    		$category = $admin->getCategory->name;

    		// get current Season
    		$season = Season::orderBy('id', 'DESC')->first()->name;

            // get selfie ids
            $selfieIds = Selfie::where('result', 2)
                            ->where('season', $season)
                            ->distinct('contestant_id')
                            ->pluck('contestant_id')
                            ->toArray();

    		// get all contestant who submitted selfie videos for the current Season
    		$result = Payment::orderBy('updated_at', 'ASC')
                            ->where('is_selfie_submitted', 1)
                            ->where('category', $category)
                            ->whereIn('registration_id', $selfieIds);

    		if($request->search != ''){
	            $result->where(function ($query) use ($request) {
	                $query->where('name', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('email', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
	            });
	        }

    		$lists = $result->paginate(20);

	        if ($request->ajax()) {
	            return view('contestant-admin..result.average.ajax-list', ['lists' => $lists])->render();    
	        }

    		return view('contestant-admin.result.average.list', compact('sideBar', "admin", "lists"));
    	}
    	else{
    		return redirect()->route('contestants.login');
    	}
    }

    public function rejectedList(Request $request)
    {
    	$sideBar = 'Rejected-List';

    	if(Session::has('contestant-admin')){
    		$email = Session::get('contestant-admin');

    		// get category
    		$admin = ContestantAdmin::where('email', $email)->first();

    		$category = $admin->getCategory->name;

    		// get current Season
    		$season = Season::orderBy('id', 'DESC')->first()->name;

            // get selfie ids
            $selfieIds = Selfie::where('result', 3)
                            ->where('season', $season)
                            ->distinct('contestant_id')
                            ->pluck('contestant_id')
                            ->toArray();

    		// get all contestant who submitted selfie videos for the current Season
    		$result = Payment::orderBy('updated_at', 'ASC')
                            ->where('is_selfie_submitted', 1)
                            ->where('category', $category)
                            ->whereIn('registration_id', $selfieIds);

    		if($request->search != ''){
	            $result->where(function ($query) use ($request) {
	                $query->where('name', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('email', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
	            });
	        }

    		$lists = $result->paginate(20);

	        if ($request->ajax()) {
	            return view('contestant-admin.result.rejected.ajax-list', ['lists' => $lists])->render();    
	        }

    		return view('contestant-admin.result.rejected.list', compact('sideBar', "admin", "lists"));
    	}
    	else{
    		return redirect()->route('contestants.login');
    	}
    }

    public function pendingList(Request $request)
    {
        $sideBar = 'Pending-List';

        if(Session::has('contestant-admin')){
            $email = Session::get('contestant-admin');

            // get category
            $admin = ContestantAdmin::where('email', $email)->first();

            $category = $admin->getCategory->name;

            // get current Season
            $season = Season::orderBy('id', 'DESC')->first()->name;

            // get all contestant who submitted selfie videos for the current Season
            $result = Payment::orderBy('updated_at', 'ASC')
                            ->where('is_selfie_submitted', 0)
                            ->where('status', 2)
                            ->where('category', $category)
                            ->where('season', $season);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('contestant-admin.result.pending.ajax-list', ['lists' => $lists])->render();    
            }

            return view('contestant-admin.result.pending.list', compact('sideBar', "admin", "lists"));
        }
        else{
            return redirect()->route('contestants.login');
        }
    }
}
