<?php

namespace App\Http\Controllers\Contestant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Redirect;
use App\ContestantAdmin;
use Session;

class LoginController extends Controller
{
    public function login()
    {
    	return view('contestant-admin.auth.login');
    }

    public function checkLogin(Request $request)
    {
    	$this->validate(request(), [
            'email' => 'required',
            'password' => 'required',
        ]);

        $email = $request->email;
        $password = $request->password;

        $checkLogin = ContestantAdmin::where('email', $email)->first();

        if ($checkLogin) {
        	if(Hash::check($password, $checkLogin->password)){
        			Session::put('contestant-admin', $checkLogin->email);
        			return redirect()->route('contestants.admin.dashboard');
        	}
        	else{
        		return Redirect::back()->withErrors(['email' => 'These credentials do not match our records.']);
        	}
        }
        else{
        	return Redirect::back()->withErrors(['email' => 'These credentials do not match our records.']);
        }
    }

    public function logout()
    {
        Session::forget('contestant-admin');

        return redirect()->route('contestants.login');
    }
}
