<?php

namespace App\Http\Controllers\Contestant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\ContestantAdmin;
use App\Feedback;

class FeedbackController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sideBar = 'Feedback-List';

        if(Session::has('contestant-admin')){
            $email = Session::get('contestant-admin');

            // get admin
            $admin = ContestantAdmin::where('email', $email)->first();

            // get feedback lists
            $lists = Feedback::where('admin_id', $admin->id)->get();

            return view('contestant-admin.feedback.list', compact('sideBar', "admin", "lists"));
        }
        else{
            return redirect()->route('contestants.login');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $sideBar = 'Feedback-List';

        if(Session::has('contestant-admin')){
            $email = Session::get('contestant-admin');

            // get admin
            $admin = ContestantAdmin::where('email', $email)->first();

            return view('contestant-admin.feedback.create', compact('sideBar', "admin"));
        }
        else{
            return redirect()->route('contestants.login');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $sideBar = 'Feedback-List';

        if(Session::has('contestant-admin')){
            $email = Session::get('contestant-admin');

            // get admin
            $admin = ContestantAdmin::where('email', $email)->first();

            $this->validate(request(), [
                'text' => 'required',
            ]);

            $text = $request->text;
            $admin_id = $admin->id;

            $store = New Feedback;
            $store->admin_id = $admin_id;
            $store->text = $text;
            $store->save();

            return redirect()->route('contestants.admin.feedback.list');
        }
        else{
            return redirect()->route('contestants.login');
        }
    }

    public function storeFeedback(Request $request)
    {
        $custom_feedback = $request->custom_feedback;

        // save into feedback list
        $email = Session::get('contestant-admin');

        // get admin
        $admin = ContestantAdmin::where('email', $email)->first();

        $text = $custom_feedback;
        $admin_id = $admin->id;

        $store = New Feedback;
        $store->admin_id = $admin_id;
        $store->text = $text;
        $store->save();

        return 1;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sideBar = 'Feedback-List';

        if(Session::has('contestant-admin')){
            $email = Session::get('contestant-admin');

            // get admin
            $admin = ContestantAdmin::where('email', $email)->first();

            $data = Feedback::find($id);

            return view('contestant-admin.feedback.edit', compact('sideBar', "admin", "data"));
        }
        else{
            return redirect()->route('contestants.login');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $sideBar = 'Feedback-List';

        if(Session::has('contestant-admin')){
            $email = Session::get('contestant-admin');

            // get admin
            $admin = ContestantAdmin::where('email', $email)->first();

            $this->validate(request(), [
                'text' => 'required',
            ]);

            $text = $request->text;
            $admin_id = $admin->id;

            $store = Feedback::find($id);
            $store->admin_id = $admin_id;
            $store->text = $text;
            $store->save();

            return redirect()->back();
        }
        else{
            return redirect()->route('contestants.login');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $destroy = Feedback::findOrFail($id);
        $destroy->delete();
        
        return back();
    }
}
