<?php

namespace App\Http\Controllers\Contestant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Session;
use App\ContestantAdmin;
use App\Season;
use App\Payment;
use App\Selfie;
use App\Feedback;
use App\ContestantFeedback;

// 0- Not Declared, 1- Best, 2- Average, 3- Rejected

class ContestantController extends Controller
{
    public function contestantList(Request $request)
    {
    	$sideBar = 'Contestant-List';

    	if(Session::has('contestant-admin')){
    		$email = Session::get('contestant-admin');

    		// get category
    		$admin = ContestantAdmin::where('email', $email)->first();

    		$category = $admin->getCategory->name;

    		// get current Season
    		$season = Season::orderBy('id', 'DESC')->first()->name;

            // get selfie ids
            $selfieIds = Selfie::where('result', 0)
                            ->where('season', $season)
                            ->distinct('contestant_id')
                            ->pluck('contestant_id')
                            ->toArray();

    		// get all contestant who submitted selfie videos for the current Season
    		$result = Payment::orderBy('updated_at', 'ASC')
                            ->where('is_selfie_submitted', 1)
                            ->where('status', 2)
                            ->where('category', $category)
                            ->whereIn('registration_id', $selfieIds);

    		if($request->search != ''){
	            $result->where(function ($query) use ($request) {
	                $query->where('name', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('email', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
	            });
	        }

    		$lists = $result->paginate(20);

	        if ($request->ajax()) {
	            return view('contestant-admin.contestant.ajax-list', ['lists' => $lists])->render();    
	        }

    		return view('contestant-admin.contestant.list', compact('sideBar', "admin", "lists"));
    	}
    	else{
    		return redirect()->route('contestants.login');
    	}
    }

    public function contestantSelfie(Request $request)
    {
        $contestant_id = $request->contestant_id;
        $season = $request->season;

        $lists = Selfie::where('contestant_id', $contestant_id)
                    ->where('season', $season)
                    ->get();

        $email = Session::get('contestant-admin');

        // get admin
        $admin = ContestantAdmin::where('email', $email)->first();

        $feedbacks = Feedback::where('admin_id', $admin->id)->get();

        // check for if feedback already given
        $checkFeedback = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->first();

        $checkFeedbackCount = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->count();

        return view('contestant-admin.contestant.ajax-selfie', ['lists' => $lists, 'contestant_id' => $contestant_id, 'season' => $season, 'feedbacks' => $feedbacks, 'checkFeedback' => $checkFeedback, 'checkFeedbackCount' => $checkFeedbackCount])->render();
    }

    public function contestantSelfieBest(Request $request)
    {
        $contestant_id = $request->contestant_id;
        $season = $request->season;

        $lists = Selfie::where('contestant_id', $contestant_id)
                    ->where('season', $season)
                    ->get();

        $email = Session::get('contestant-admin');

        // get admin
        $admin = ContestantAdmin::where('email', $email)->first();

        $feedbacks = Feedback::where('admin_id', $admin->id)->get();

        // check for if feedback already given
        $checkFeedback = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->first();

        $checkFeedbackCount = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->count();

        return view('contestant-admin.result.best.ajax-selfie', ['lists' => $lists, 'contestant_id' => $contestant_id, 'season' => $season, 'feedbacks' => $feedbacks, 'checkFeedback' => $checkFeedback, 'checkFeedbackCount' => $checkFeedbackCount])->render();
    }

    public function contestantSelfieAverage(Request $request)
    {
        $contestant_id = $request->contestant_id;
        $season = $request->season;

        $lists = Selfie::where('contestant_id', $contestant_id)
                    ->where('season', $season)
                    ->get();

        $email = Session::get('contestant-admin');

        // get admin
        $admin = ContestantAdmin::where('email', $email)->first();

        $feedbacks = Feedback::where('admin_id', $admin->id)->get();

        // check for if feedback already given
        $checkFeedback = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->first();

        $checkFeedbackCount = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->count();

        return view('contestant-admin.result.average.ajax-selfie', ['lists' => $lists, 'contestant_id' => $contestant_id, 'season' => $season, 'feedbacks' => $feedbacks, 'checkFeedback' => $checkFeedback, 'checkFeedbackCount' => $checkFeedbackCount])->render();
    }

    public function contestantSelfieReject(Request $request)
    {
        $contestant_id = $request->contestant_id;
        $season = $request->season;

        $lists = Selfie::where('contestant_id', $contestant_id)
                    ->where('season', $season)
                    ->get();

        $email = Session::get('contestant-admin');

        // get admin
        $admin = ContestantAdmin::where('email', $email)->first();

        $feedbacks = Feedback::where('admin_id', $admin->id)->get();

        // check for if feedback already given
        $checkFeedback = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->first();

        $checkFeedbackCount = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->count();

        return view('contestant-admin.result.rejected.ajax-selfie', ['lists' => $lists, 'contestant_id' => $contestant_id, 'season' => $season, 'feedbacks' => $feedbacks, 'checkFeedback' => $checkFeedback, 'checkFeedbackCount' => $checkFeedbackCount])->render();
    }

    public function contestantSelfieResult(Request $request)
    {
        $contestant_id = $request->contestant_id;
        $season = $request->season;
        $result = $request->result;

        $update = Selfie::where('contestant_id', $contestant_id)
                    ->where('season', $season)
                    ->update(['result' => $result]);

        return $result;
    }

    public function contestantSelfieFeedback(Request $request)
    {
        $contestant_id = $request->contestant_id;
        $season = $request->season;
        $feedback_id = isset($request->feedback_id) ? $request->feedback_id : [];
        $custom_feedback = $request->custom_feedback;
        $custom_feedback_check = $request->custom_feedback_check;

        // check for if feedback already given
        $checkFeedback = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->count();

        if($checkFeedback > 0){
            $update = ContestantFeedback::where('contestant_id', $contestant_id)
                                ->where('season', $season)
                                ->update([
                                    'feedback_id' => json_encode($feedback_id),
                                    'custom_feedback' => $custom_feedback,
                                ]);
            return 2;
        }
        else{
            if($custom_feedback_check == 1 && $custom_feedback != ''){
                // save into feedback list
                $email = Session::get('contestant-admin');

                // get admin
                $admin = ContestantAdmin::where('email', $email)->first();

                $text = $custom_feedback;
                $admin_id = $admin->id;

                $store = New Feedback;
                $store->admin_id = $admin_id;
                $store->text = $text;
                $store->save();
            }

            $store = New ContestantFeedback;
            $store->contestant_id = $contestant_id;
            $store->season = $season;
            $store->feedback_id = json_encode($feedback_id);
            $store->custom_feedback = $custom_feedback;
            $store->save();

            return 1;
        }
    }

    public function contestantSelfieDelete(Request $request)
    {
        $contestant_id = $request->contestant_id;
        $season = $request->season;

        $lists = Selfie::where('contestant_id', $contestant_id)
                    ->where('season', $season)
                    ->get();

        foreach ($lists as $list) {
            // delete file from S3
            $q = Storage::disk('s3')->delete(str_replace('https://talentriangle.s3-ap-southeast-1.amazonaws.com/', '', $list->link));
        }

        return 1;
    }
}
