<?php

namespace App\Http\Controllers\Contestant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\ContestantAdmin;
use App\Registration;
use App\Audition;
use Session;

class AuditionController extends Controller
{
    public function index(Request $request)
    {
    	$sideBar = 'Audition-List';

        if(Session::has('contestant-admin')){
            $email = Session::get('contestant-admin');

            // get admin
            $admin = ContestantAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
	            				->where('is_selfie_submitted', 1)
	            				->distinct('registration_id')
	                            ->pluck('registration_id')
	                            ->toArray();

            // get all registration who submitted selfie videos
    		$result = Registration::orderBy('updated_at', 'ASC')
	                            ->where('category', $admin->getCategory->name)
	                            ->whereIn('id', $auditionIds);

    		if($request->search != ''){
	            $result->where(function ($query) use ($request) {
	                $query->where('name', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('email', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
	            });
	        }

    		$lists = $result->paginate(20);

	        if ($request->ajax()) {
	            return view('contestant-admin.audition.ajax-list', ['lists' => $lists])->render();    
	        }

    		return view('contestant-admin.audition.list', compact('sideBar', "admin", "lists"));
        }
        else{
            return redirect()->route('contestants.login');
        }
    }

    public function auditionSelfie(Request $request)
    {
        $registration_id = $request->registration_id;

        $lists = Audition::where('registration_id', $registration_id)->get();

        $email = Session::get('contestant-admin');

        // get admin
        $admin = ContestantAdmin::where('email', $email)->first();

        return view('contestant-admin.audition.ajax-selfie', ['lists' => $lists, 'registration_id' => $registration_id])->render();
    }

    public function auditionSelfieResult(Request $request)
    {
        $registration_id = $request->registration_id;
        $result = $request->result;

        $update = Audition::where('registration_id', $registration_id)
                    	->update(['result' => $result]);

        return $result;
    }
}
