<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\File;
use Redirect;
use Session;
use App\Registration;
Use App\Audition;
use App\Selfie;
use App\Season;
use App\State;
use App\City;
use App\Category;
use Carbon\Carbon;

class AuditionController extends Controller
{
    public function audition()
    {
        if(Session::has('registration-phone')){
            $phone = Session::get('registration-phone');

            $checkRegistration = Registration::where('phone', $phone)->count();

            if($checkRegistration == 0){
                return redirect()->route('audition.form.fill');
            }
            else{
                // get registration ids
                $ids = Registration::where('phone', $phone)->pluck('id')->toArray();

                // find ids in table auditions
                $find = Audition::orderBy('id', 'DESC')
                                ->whereIn('registration_id', $ids)
                                ->where('is_selfie_submitted', 1)
                                ->where('result', '!=', 0)
                                ->count();

                if($find > 0){
                     return redirect()->route('audition.selfie.result');
                }

                // return redirect()->route('audition.dashboard');
                return redirect()->route('audition.selfie.video');
            }
        }
        else{
            return view('audition.auth.login');
        }
    }

    public function auditionLogin(Request $request)
    {
        $this->validate(request(), [
            'phone' => 'required|min:10',
        ]);

        $phone = $request->phone;

        $checkRegistration = Registration::where('phone', $phone)->count();

        if($checkRegistration == 0){
            Session::put('registration-phone', $phone);
            return redirect()->route('audition.form.fill');
        }
        else{
            Session::put('registration-phone', $phone);

            // get registration ids
            $ids = Registration::where('phone', $phone)->pluck('id')->toArray();

            // find ids in table auditions
            $find = Audition::orderBy('id', 'DESC')
                            ->whereIn('registration_id', $ids)
                            ->where('is_selfie_submitted', 1)
                            ->where('result', '!=', 0)
                            ->count();

            if($find > 0){
                return redirect()->route('audition.selfie.result');
            }

            // return redirect()->route('audition.dashboard');
            return redirect()->route('audition.selfie.video');
        }
    }

    public function auditionForm()
    {
        $sideBar = 'Profile';

        $states = State::get();
        $cities = City::where('state_code', 'AN')->get();
        $categories = Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();

        if(Session::has('registration-phone')){
            return view('audition.form', compact('sideBar', 'states', 'cities', 'categories'));
        }
        else{
            return view('audition.auth.login');
        }
    }

    public function auditionFormSubmit(Request $request)
    {
        $this->validate(request(), [
            'name' => 'required',
            'email' => 'required',
            'category' => 'required',
            'gender' => 'required',
            'age_group' => 'required',
            'state' => 'required',
            'city' => 'required',
        ]);

        if(Session::has('registration-phone')){
            $name = $request->name;
            $email = $request->email;
            $phone = Session::get('registration-phone');
            $category = $request->category;
            $gender = $request->gender;
            $age_group = $request->age_group;
            $state = $request->state;
            $city = $request->city;

            // get last season value
            $season = Season::orderBy('id', 'DESC')->first();

            $count = Registration::where('phone', $phone)
                                ->where('category', $category)
                                ->count();

            if($count == 0){
                $registration = New Registration;
                $registration->name = $name;
                $registration->email = $email;
                $registration->phone = $phone;
                $registration->category = $category;
                $registration->gender = $gender;
                $registration->age_group = $age_group;
                $registration->state = $state;
                $registration->city = $city;
                $registration->season = $season->name;
                $registration->platform = 'Audition';
                $registration->created_at = Carbon::now();
                $registration->updated_at = Carbon::now();
                $registration->save();
            }

            return redirect()->route('audition.selfie.video');
        }
        else{
            return view('audition.auth.login');
        }
    }

    public function dashboard()
    {
        $sideBar = 'Profile';

        if(Session::has('registration-phone')){
            $phone = Session::get('registration-phone');

            $categories = Category::where('on_payment_page', 1)->pluck('name')->toArray();

            // get detial
            $getRegistrations = Registration::where('phone', $phone)->whereIn('category', $categories)->get();

            if(count($getRegistrations) == 0){
                return redirect()->route('audition.form.fill');
            }

            return view('audition.dashboard', compact('sideBar', 'getRegistrations'));
        }
        else{
            return redirect()->route('audition.login');
        }
    }

    public function selfieVideo()
    {
        $sideBar = 'Selfie-Video';
        
        if(Session::has('registration-phone')){
            $phone = Session::get('registration-phone');

            $categories = Category::where('on_payment_page', 1)->pluck('name')->toArray();

            // get detial
            $getRegistrations = Registration::where('phone', $phone)->whereIn('category', $categories)->get();

            if(count($getRegistrations) == 0){
                return redirect()->route('audition.form.fill');
            }

            return view('audition.selfie', compact('sideBar', 'getRegistrations'));
        }
        else{
            return redirect()->route('audition.login');
        }
    }

    public function selfieResult()
    {
        $sideBar = 'My-Result';
        
        if(Session::has('registration-phone')){
            $phone = Session::get('registration-phone');

            $categories = Category::where('on_payment_page', 1)->pluck('name')->toArray();

            // get detial
            $getRegistrations = Registration::where('phone', $phone)->whereIn('category', $categories)->get();

            if(count($getRegistrations) == 0){
                return redirect()->route('audition.form.fill');
            }

            $getRegistrationIds = Registration::where('phone', $phone)->pluck('id')->toArray();

            // check if user did not submitted audition videos
            $auditionResultCount = Audition::whereIn('registration_id', $getRegistrationIds)
                                        ->where('is_selfie_submitted', 1)
                                        ->whereIn('result', [1, 2, 4])
                                        ->count();

            if($auditionResultCount == 0){
                return redirect()->route('audition.selfie.video');
            }

            return view('audition.result', compact('sideBar', 'getRegistrations'));
        }
        else{
            return redirect()->route('audition.login');
        }
    }

    public function selfieUpload(Request $request)
    {
        if(Session::has('registration-phone')){
            $phone = Session::get('registration-phone');

            $registration_id = $request->id;

            $size = $request->file->getClientSize();

            // get detial
            $getRegistration = Registration::where('id', $registration_id)->first();
            
            // 1258291200
            if($size > 1258291200){
                $file = $request->file('file');
                $ext = $request->file->getClientOriginalExtension();
                $file_name = md5(time()).'.'.$ext;
                $destinationPath = storage_path('app/public/videos');
                $file->move($destinationPath, $file_name);
    
                // $ffmpeg = 'C:/ffmpeg/bin/ffmpeg.exe';
                $ffmpeg = '/home/talentri/ffmpeg-4.3.1-i686-static/ffmpeg';
                $inpath = storage_path("app/public/videos/".$file_name);
                $file_name_new = md5(time()).'.ogg';
                $outpath = storage_path("app/public/auditions/".$file_name_new);

                $cmd = "$ffmpeg -i $inpath -b 450k -strict -2 $outpath";
                $return = `$cmd`;

                $path = Storage::disk('s3')->putFileAs('auditions/'.$getRegistration->phone, new File($outpath), $file_name_new, 'public');

                $file_link = storage_path('app/public/videos/'.$file_name);
                if(is_file($file_link)){
                    unlink($file_link);
                }

                $file_link_new = storage_path('app/public/auditions/'.$file_name_new);
                if(is_file($file_link_new)){
                    unlink($file_link_new);
                }

                // insert into database
                $insert = New Audition;
                $insert->registration_id = $registration_id;
                $insert->category = $getRegistration->category;
                $insert->link = 'https://talentriangle.s3-ap-southeast-1.amazonaws.com/'.$path;
                $insert->save();
            }
            else{
                $path = Storage::disk('s3')->put('auditions/'.$getRegistration->phone, $request->file('file'));
                $request->merge([
                    'size' => $request->file->getClientSize(),
                    'path' => $path
                ]);

                // insert into database
                $insert = New Audition;
                $insert->registration_id = $registration_id;
                $insert->category = $getRegistration->category;
                $insert->link = 'https://talentriangle.s3-ap-southeast-1.amazonaws.com/'.$path;
                $insert->save();
            }

            return 1;
        }
        else{
            return 0;
        }
    }

    public function selfieRemove(Request $request, $id)
    {
        $getFile = Audition::find($id);

        // delete file from S3
        $q = Storage::disk('s3')->delete(str_replace('https://talentriangle.s3-ap-southeast-1.amazonaws.com/', '', $getFile->link));

        // delete file from db
        $destroy = Audition::findOrFail($id);
        $destroy->delete();
        
        return back();
    }

    public function selfieSubmit(Request $request)
    {
        if(Session::has('registration-phone')){
            $phone = Session::get('registration-phone');

            // update detial
            $update = Audition::where('id', $request->audition_id)->update(['is_selfie_submitted'=>1]);

            return redirect()->back()->withErrors(['response' => "Thank you for submitting your audition video your result will be declared here only in the next 24-48 hours."]);
        }
        else{
            Session::forget('registration-phone');

            return redirect()->route('audition.login');
        }
    }

    public function logout()
    {
        Session::forget('registration-phone');

        return redirect()->route('audition.login');
    }
}
