<?php

namespace App\Http\Controllers\Audition;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\AuditionAdmin;
use App\Message;
use App\ResultType;
use Session;

class MessageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sideBar = 'Message-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            $lists = Message::where('admin_id', $admin->id)->get();

            return view('audition-admin.message.list', compact('sideBar', "admin", "lists"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $sideBar = 'Message-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            $lists = Message::where('admin_id', $admin->id)->pluck('type')->toArray();

            // get result types
            $types = ResultType::whereNotIn('id', $lists)->get();

            return view('audition-admin.message.create', compact('sideBar', "admin", "types"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $sideBar = 'Message-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            $this->validate(request(), [
                'message' => 'required',
                'type' => 'required',
            ]);

            $message = $request->message;
            $type = $request->type;
            $admin_id = $admin->id;

            $store = New Message;
            $store->admin_id = $admin_id;
            $store->type = $type;
            $store->message = $message;

            if(isset($request->link_label) && $type == 1){
                $store->link_label = $request->link_label;
            }

            if(isset($request->link) && $type == 1){
                $store->link = $request->link;
            }

            // if audio file uploaded
            if($request->hasFile('file') && $type == 1){
                $audio = $request->file('file');
                $extention = $request->file('file')->extension();
                $file_name = md5(time()).'.'.$extention;
                $destinationPath = storage_path('/file');
                $audio->move($destinationPath, $file_name);
                $store->file = $file_name;
            }

            if(isset($request->last_message) && $type == 1){
                $store->last_message = $request->last_message;
            }

            $store->save();

            return redirect()->route('auditions.admin.message.index');
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sideBar = 'Message-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            $data = Message::find($id);

            return view('audition-admin.message.edit', compact('sideBar', "admin", "data"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $sideBar = 'Message-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            $this->validate(request(), [
                'message' => 'required',
            ]);

            $message = $request->message;

            $store = Message::find($id);
            $store->message = $message;

            if(isset($request->link_label) && $store->type == 1){
                $store->link_label = $request->link_label;
            }

            if(isset($request->link) && $store->type == 1){
                $store->link = $request->link;
            }

            // if audio file uploaded
            if($request->hasFile('file') && $store->type == 1){
                if($store->file != '' && file_exists(storage_path('/file/'.$store->file))){
                    unlink(storage_path('/file/'.$store->file));
                }

                $audio = $request->file('file');
                $extention = $request->file('file')->extension();
                $file_name = md5(time()).'.'.$extention;
                $destinationPath = storage_path('/file');
                $audio->move($destinationPath, $file_name);
                $store->file = $file_name;
            }

            if(isset($request->last_message) && $store->type == 1){
                $store->last_message = $request->last_message;
            }

            $store->save();

            return redirect()->back();
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $destroy = Message::findOrFail($id);
        
        if($destroy->file != '' && file_exists(storage_path('/file/'.$destroy->file))){
            unlink(storage_path('/file/'.$destroy->file));
        }

        $destroy->delete();
        
        return back();
    }
}
