<?php

namespace App\Http\Controllers\Audition;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\AuditionAdmin;
use Redirect;
use Session;

class LoginController extends Controller
{
    public function login()
    {
    	return view('audition-admin.auth.login');
    }

    public function checkLogin(Request $request)
    {
    	$this->validate(request(), [
            'email' => 'required',
            'password' => 'required',
        ]);

        $email = $request->email;
        $password = $request->password;

        $checkLogin = AuditionAdmin::where('email', $email)->first();

        if ($checkLogin) {
        	if(Hash::check($password, $checkLogin->password)){
        			Session::put('audition-admin', $checkLogin->email);
        			return redirect()->route('auditions.admin.dashboard');
        	}
        	else{
        		return Redirect::back()->withErrors(['email' => 'These credentials do not match our records.']);
        	}
        }
        else{
        	return Redirect::back()->withErrors(['email' => 'These credentials do not match our records.']);
        }
    }

    public function logout()
    {
        Session::forget('audition-admin');

        return redirect()->route('auditions.login');
    }
}
