<?php

namespace App\Http\Controllers\Audition;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use App\Exports\AuditionExport;
use App\Exports\LastMessageExport;
use Maatwebsite\Excel\Facades\Excel;
use App\Traits\SendMsg;
use App\AuditionAdmin;
use App\Registration;
use App\Audition;
use App\Message;
use App\Category;
use Carbon\Carbon;
use Session;

class AuditionController extends Controller
{
    use SendMsg;

    public function index(Request $request)
    {
    	$sideBar = 'Audition-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_selfie_submitted', 1)
                                ->where('result', 0)
	            				->where('is_deleted', 0)
	            				->distinct('registration_id')
	                            ->pluck('registration_id')
	                            ->toArray();

            // get all registration who submitted selfie videos
    		$result = Registration::orderBy('updated_at', 'ASC')
	                            ->where('category', $admin->getCategory->name)
	                            ->whereIn('id', $auditionIds);

    		if($request->search != ''){
	            $result->where(function ($query) use ($request) {
	                $query->where('name', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('email', 'LIKE', '%'.$request->search.'%')
	                    ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
	            });
	        }

    		$lists = $result->paginate(20);

	        if ($request->ajax()) {
	            return view('audition-admin.audition.ajax-list', ['lists' => $lists])->render();    
	        }

            $type = 0;

    		return view('audition-admin.audition.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function best(Request $request)
    {
        $sideBar = 'Best-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_selfie_submitted', 1)
                                ->where('is_best', 1)
                                ->where('is_deleted', 0)
                                ->distinct('registration_id')
                                ->pluck('registration_id')
                                ->toArray();

            // get all registration who submitted selfie videos
            $result = Registration::orderBy('updated_at', 'ASC')
                                ->where('category', $admin->getCategory->name)
                                ->whereIn('id', $auditionIds);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('audition-admin.best.ajax-list', ['lists' => $lists])->render();    
            }

            $type = 1;

            return view('audition-admin.best.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function seleted(Request $request)
    {
        $sideBar = 'Selected-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_selfie_submitted', 1)
                                ->where('result', 1)
                                ->where('is_deleted', 0)
                                ->distinct('registration_id')
                                ->pluck('registration_id')
                                ->toArray();

            // get all registration who submitted selfie videos
            $result = Registration::orderBy('updated_at', 'ASC')
                                ->where('category', $admin->getCategory->name)
                                ->whereIn('id', $auditionIds);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('audition-admin.result.selected.ajax-list', ['lists' => $lists])->render();    
            }

            $type = 1;

            return view('audition-admin.result.selected.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function rejected(Request $request)
    {
        $sideBar = 'Rejected-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_selfie_submitted', 1)
                                ->where('result', 2)
                                ->where('is_deleted', 0)
                                ->distinct('registration_id')
                                ->pluck('registration_id')
                                ->toArray();

            // get all registration who submitted selfie videos
            $result = Registration::orderBy('updated_at', 'ASC')
                                ->where('category', $admin->getCategory->name)
                                ->whereIn('id', $auditionIds);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('audition-admin.audition.ajax-list', ['lists' => $lists])->render();    
            }

            $type = 2;

            return view('audition-admin.audition.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function reinvite(Request $request)
    {
        $sideBar = 'Re-Invited-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_selfie_submitted', 0)
                                ->where('result', 3)
                                ->where('is_deleted', 0)
                                ->distinct('registration_id')
                                ->pluck('registration_id')
                                ->toArray();

            // get all registration who submitted selfie videos
            $result = Registration::orderBy('updated_at', 'ASC')
                                ->where('category', $admin->getCategory->name)
                                ->whereIn('id', $auditionIds);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('audition-admin.audition.ajax-list', ['lists' => $lists])->render();    
            }

            $type = 3;

            return view('audition-admin.audition.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function lastMessage(Request $request)
    {
        $sideBar = 'Last-Message-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_selfie_submitted', 1)
                                ->where('result', 4)
                                ->where('is_deleted', 0)
                                ->distinct('registration_id')
                                ->pluck('registration_id')
                                ->toArray();

            // get all registration who submitted selfie videos
            $result = Registration::orderBy('updated_at', 'ASC')
                                ->where('category', $admin->getCategory->name)
                                ->whereIn('id', $auditionIds);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('audition-admin.audition.ajax-list', ['lists' => $lists])->render();    
            }

            $type = 4;

            return view('audition-admin.last.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function nonSubmit(Request $request)
    {
        $sideBar = 'Non-Submit-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_selfie_submitted', 0)
                                ->distinct('registration_id')
                                ->pluck('registration_id')
                                ->toArray();

            // get all registration who submitted selfie videos
            $result = Registration::orderBy('updated_at', 'ASC')
                                ->where('category', $admin->getCategory->name)
                                ->whereIn('id', $auditionIds);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('audition-admin.audition.ajax-list', ['lists' => $lists])->render();    
            }

            $type = 3;

            return view('audition-admin.audition.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function deletedVideo(Request $request)
    {
        $sideBar = 'Deleted-Video-List';

        if(Session::has('audition-admin')){
            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            // get audition ids
            $auditionIds = Audition::where('category', $admin->getCategory->name)
                                ->where('is_deleted', 1)
                                ->distinct('registration_id')
                                ->pluck('registration_id')
                                ->toArray();

            // get all registration who submitted selfie videos
            $result = Registration::orderBy('updated_at', 'ASC')
                                ->where('category', $admin->getCategory->name)
                                ->whereIn('id', $auditionIds);

            if($request->search != ''){
                $result->where(function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                        ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
                });
            }

            $lists = $result->paginate(20);

            if ($request->ajax()) {
                return view('audition-admin.deleted.ajax-list', ['lists' => $lists])->render();    
            }

            $type = 3;

            return view('audition-admin.deleted.list', compact('sideBar', "admin", "lists", "type"));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function auditionSelfie(Request $request)
    {
        $registration_id = $request->registration_id;

        $lists = Audition::where('registration_id', $registration_id)->get();

        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        $messages = Message::where('admin_id', $admin->id)->get();

        $registration = Registration::find($registration_id);

        return view('audition-admin.audition.ajax-selfie', ['lists' => $lists, 'registration_id' => $registration_id, 'messages' => $messages, 'registration' => $registration])->render();
    }

    public function auditionSelfieLast(Request $request)
    {
        $registration_id = $request->registration_id;

        $lists = Audition::where('registration_id', $registration_id)->get();

        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        $messages = Message::where('admin_id', $admin->id)->get();

        $registration = Registration::find($registration_id);

        return view('audition-admin.last.ajax-selfie', ['lists' => $lists, 'registration_id' => $registration_id, 'messages' => $messages, 'registration' => $registration])->render();
    }

    public function auditionBest(Request $request)
    {
        $registration_id = $request->registration_id;

        $lists = Audition::where('registration_id', $registration_id)->get();

        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        $messages = Message::where('admin_id', $admin->id)->get();

        $registration = Registration::find($registration_id);

        return view('audition-admin.best.ajax-selfie', ['lists' => $lists, 'registration_id' => $registration_id, 'messages' => $messages, 'registration' => $registration])->render();
    }

    public function auditionSelfieSeleted(Request $request)
    {
        $registration_id = $request->registration_id;

        $lists = Audition::where('registration_id', $registration_id)->get();

        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        $messages = Message::where('admin_id', $admin->id)->get();

        $registration = Registration::find($registration_id);

        return view('audition-admin.result.selected.ajax-selfie', ['lists' => $lists, 'registration_id' => $registration_id, 'messages' => $messages, 'registration' => $registration])->render();
    }

    public function auditionSelfieDelete(Request $request)
    {
        $registration_id = $request->registration_id;

        $lists = Audition::where('registration_id', $registration_id)->get();

        foreach ($lists as $list) {
            // delete file from S3
            $q = Storage::disk('s3')->delete(str_replace('https://talentriangle.s3-ap-southeast-1.amazonaws.com/', '', $list->link));

            // update is delete in table
            $destroy = Audition::findOrFail($list->id);
            $destroy->is_deleted = 1;
            $destroy->save();
        }

        return 1;
    }

    public function auditionSelfieDeleteList(Request $request)
    {
        $registration_id = $request->registration_id;

        $lists = Audition::where('registration_id', $registration_id)->get();

        foreach ($lists as $list) {
            // delete from table
            $destroy = Audition::findOrFail($list->id);
            $destroy->delete();
        }

        return 1;
    }

    public function auditionSelfieResult(Request $request)
    {
        $registration_id = $request->registration_id;
        $result = $request->result;

        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        // check admin have message list
        $messageCount = Message::where('admin_id', $admin->id)->count();
        if($messageCount < 3){
            return 4;
        }

        $message = Message::where('admin_id', $admin->id)->where('type', $result)->first();
        if($result == 1){
            $update = Audition::where('registration_id', $registration_id)
                        ->update([
                            'is_selfie_submitted' => 1,
                            'result' => $result,
                            'message' => $message->message,
                            'link_label' => $message->link_label,
                            'prep_link' => $message->link,
                            'file_link' => $message->file
                        ]);
        }

        if($result == 2){
            $update = Audition::where('registration_id', $registration_id)
                        ->update([
                            'is_selfie_submitted' => 1,
                            'result' => $result,
                            'message' => $message->message
                        ]);
        }

        if($result == 3){
            $feedback = $request->feedback;

            $update = Audition::where('registration_id', $registration_id)
                        ->update([
                            'is_selfie_submitted' => 0,
                            'result' => $result,
                            'message' => $message->message,
                            'feedback' => $feedback
                        ]);
        }

        return $result;
    }

    public function auditionSelfieBest(Request $request)
    {
        $registration_id = $request->registration_id;

        $update = Audition::where('registration_id', $registration_id)
                        ->update([
                            'is_best' => 1,
                        ]);

        return 1;
    }

    public function auditionSelfieChangeCategory(Request $request)
    {
        $registration_id = $request->registration_id;
        $category = $request->category;

        if($category != ''){
            // change registration category
            $update = Registration::find($registration_id);
            $update->category = $category;
            $update->save();

            // change audition category
            $updateAudition = Audition::where('registration_id', $registration_id)->update(['category'=>$category]);

            return 1;
        }
        else{
            return 2;
        }
    }

    public function auditionSelfieMoveToLast(Request $request)
    {
        $from = $request->from_date;
        $to = $request->to_date;

        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        // check admin have message list
        $messageCount = Message::where('admin_id', $admin->id)
                                ->where('type', 1)
                                ->where('last_message', '!=', '')
                                ->count();
        if($messageCount < 1){
            return 4;
        }

        $message = Message::where('admin_id', $admin->id)->where('type', 1)->first();

        if($from != '' && $to != ''){
            if(strtotime($from) == strtotime($to)){
                $update = Audition::where('result', 1)
                                ->whereDate('updated_at', $from)
                                ->update([
                                    'last_message'=>$message->last_message,
                                    'result' => 4
                                ]);
            }
            else{
                $update = Audition::where('result', 1)
                                ->whereBetween('updated_at', [$from, $to])
                                ->update([
                                    'last_message'=>$message->last_message,
                                    'result' => 4
                                ]);
            }
        }

        return 1;
    }

    public function auditionSelfieSendsms(Request $request)
    {
        $registration_id = $request->registration_id;
        $type = $request->type;

        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        // check admin have message list
        $message = Message::where('admin_id', $admin->id)
                            ->where('type', $type)
                            ->first();
        if($message){
            $registration = Registration::find($registration_id);

            $phone = $registration->phone;
            $message = $message->message;

            $msg = $this->SendSimpleMsg($phone, $message);

            return 1;
        }
        else{
            return 2;
        }
    }

    public function edit($id)
    {
        if(Session::has('audition-admin')){
            $sideBar = '';

            $data = Registration::find($id);

            $categories = Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();

            $email = Session::get('audition-admin');

            // get admin
            $admin = AuditionAdmin::where('email', $email)->first();

            return view('audition-admin.edit', compact('sideBar', 'data', 'categories', 'admin'));
        }
        else{
            return redirect()->route('auditions.login');
        }
    }

    public function update(Request $request, $id)
    {
        $this->validate(request(), [
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'category' => 'required',
            'age_group' => 'required',
        ]);

        $name = $request->name;
        $email = $request->email;
        $phone = $request->phone;
        $category = $request->category;
        $age_group = $request->age_group;

        $update = Registration::find($id);
        $update->name = $name;
        $update->email = $email;
        $update->phone = $phone;
        $update->category = $category;
        $update->age_group = $age_group;
        $update->updated_at = Carbon::now();
        $update->save();

        return redirect()->route('auditions.admin.audition.list');
    }

    public function export(Request $request, $type) 
    {
        if($type == 1){
            return Excel::download(new AuditionExport(), 'Audition-List(Selected).csv');
        }
        
        if($type == 4){
            return Excel::download(new LastMessageExport(), 'Audition-List(Last-Message).csv');
        }
    }
}
