<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Season;

class SeasonController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $sideBar = 'Seasons';

        $lists = Season::orderBy('id', 'DESC')->get();

        return view('admin.seasons.list', compact('sideBar', "lists"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $sideBar = 'Seasons';

        return view('admin.seasons.create', compact('sideBar'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate(request(), [
            'name' => 'required|unique:seasons',
        ]);

        $name = $request->name;

        $store = New Season;
        $store->name = $name;
        $store->save();

        return redirect()->route('admin.seasons.index');

        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sideBar = 'Seasons';

        $data = Season::find($id);

        return view('admin.seasons.edit', compact('sideBar', 'data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(request(), [
            'name' => 'required|unique:seasons',
        ]);

        $name = $request->name;

        $store = Season::find($id);
        $store->name = $name;
        $store->save();

        return redirect()->route('admin.seasons.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $destroy = Season::findOrFail($id);
        $destroy->delete();
        
        return back();
    }
}
