<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Traits\SendMsg;

class MessageController extends Controller
{
	use SendMsg;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $sideBar = 'Message';

        return view('admin.message.index', compact('sideBar'));
    }

    public function sendMessage(Request $request)
    {
    	$this->validate(request(), [
            'phone' => 'required',
            'message' => 'required',
        ]);

    	$phoneTmp = $request->phone;

        // remove space and place comma
        $phone = str_replace(" ", ",", $phoneTmp);
    	$message = $request->message;

    	$msg = $this->SendMultipleMsg($phone, $message);

    	return redirect()->back()->withErrors(['response' => 'Message Sent Successfully!']);
    }
}
