<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\MailSetting;

class MailSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $sideBar = 'MailSetting';

        $lists = MailSetting::orderBy('id', 'DESC')->get();

        return view('admin.mail-setting.list', compact('sideBar', "lists"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $sideBar = 'MailSetting';

        return view('admin.mail-setting.create', compact('sideBar'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate(request(), [
            'email' => 'required',
            'password' => 'required',
            'status' => 'required',
        ]);

        $email = $request->email;
        $password = $request->password;
        $status = ($request->status == 'yes' ? 1 : 0);

        $store = New MailSetting;
        $store->email = $email;
        $store->password = $password;
        $store->status = $status;
        $store->save();

        return redirect()->route('admin.mail-setting.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sideBar = 'MailSetting';

        $data = MailSetting::find($id);

        return view('admin.mail-setting.edit', compact('sideBar', 'data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(request(), [
            'email' => 'required',
            'status' => 'required',
        ]);

        if(isset($request->change_password)){
            $this->validate(request(), [
                'password' => 'required'
            ]);

            $password = $request->password;
        }

        $email = $request->email;
        $status = ($request->status == 'yes' ? 1 : 0);

        $update = MailSetting::find($id);
        $update->email = $email;

        if(isset($request->change_password)){
            $update->password = $password;
        }
        
        $update->status = $status;
        $update->save();

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $destroy = MailSetting::findOrFail($id);
        $destroy->delete();
        
        return back();
    }
}
