<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\MailSetting;
use Config;
use Mail;

class MailController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $sideBar = 'Mail';

        $mails = MailSetting::orderBy('id', 'DESC')->where('status', 1)->get();

        return view('admin.mail.index', compact('sideBar', 'mails'));
    }

    public function sendMail(Request $request)
    {
    	$this->validate(request(), [
    		'mail' => 'required',
            'email' => 'required',
            'subject' => 'required',
        ]);

    	$emailTmp = $request->email;

    	// change emails string into array
    	$emails = explode(" ", $emailTmp);
        $subject = $request->subject;
    	$msg = $request->message;

    	// get mail configuration
    	$mailData = MailSetting::find($request->mail);

    	Config::set('mail.username', $mailData->email);
    	Config::set('mail.password', $mailData->password);

    	for ($i=0; $i < count($emails); $i++) { 
    		$email = $emails[$i];
    		$data = array('email'=>$email, 'subject'=>$subject, 'msg' => $msg);

            try {
                Mail::send('admin.mail.template', $data, function($message) use ($email, $mailData, $subject) {
                    $message->to($email)->subject($subject);
                    $message->from($mailData->email, 'TalenTriangle.com');
                });

                return 1;
            }
            catch (\Exception $e) {
                return 2;
            }
    	}

    	return redirect()->back()->withErrors(['response' => 'Mail Sent Successfully!']);
    }
}
