<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Category;
use App\Registration;
use App\Payment;
use Carbon\Carbon;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function index(Request $request)
    {
        $sideBar = 'Home';

        $categories = Category::count();

        $registrations = Registration::count();
        $todaysRegistrations = Registration::whereDate('updated_at', Carbon::today())->count();

        $paidPaymentsMem = Payment::where('status', 2)->where('membership', 1)->count();
        $todaysPaidPaymentsMem = Payment::where('status', 2)->where('membership', 1)->whereDate('payment_at', Carbon::today())->count();
        $unPaidPaymentsMem = Payment::where('status', 0)->where('membership', 1)->count();

        $paidPaymentsOne = Payment::where('status', 2)->where('membership', 0)->count();
        $todaysPaidPaymentsOne = Payment::where('status', 2)->where('membership', 0)->whereDate('payment_at', Carbon::today())->count();
        $unPaidPaymentsOne = Payment::where('status', 0)->where('membership', 0)->count();
        
        $todaysDate = Carbon::now();

        return view('admin.home', compact('sideBar', "categories", "registrations", "todaysRegistrations", "paidPaymentsMem", "todaysPaidPaymentsMem", "unPaidPaymentsMem", "paidPaymentsOne", "todaysPaidPaymentsOne", "unPaidPaymentsOne", "todaysDate"));
    }
}
