<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Payment;
use App\Selfie;
use App\Category;
use Session;

class ContestantController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $sideBar = 'ContestantList';

        // get audition ids
        $selfieIdsTmp = Selfie::orderBy('season', 'DESC');

        // if from date and to date
        if($request->from_date != '' && $request->to_date != ''){
            if(strtotime($request->from_date) == strtotime($request->to_date)){
                $selfieIdsTmp->where(function ($query) use ($request) {
                    $query->whereDate('updated_at', $request->from_date);
                });
            }
            else{
                $selfieIdsTmp->where(function ($query) use ($request) {
                    $query->whereBetween('updated_at', [$request->from_date, $request->to_date]);
                });
            }
        }

        // if result
        if($request->result != '' && $request->result != 'all'){
            $selfieIdsTmp->where(function ($query) use ($request) {
                $query->where('result', $request->result);
            });
        }

        $selfieIds = $selfieIdsTmp->distinct('contestant_id')
                            ->pluck('contestant_id')
                            ->toArray();

        // get all payments who submitted selfie videos
        $result = Payment::orderBy('updated_at', 'ASC')
                        ->whereIn('registration_id', $selfieIds);

        // if category
        if($request->category != '' && $request->category != 'all'){
            $result->where(function ($query) use ($request) {
                $query->where('category', $request->category);
            });
        }

        // if search
        if($request->search != ''){
            $result->where(function ($query) use ($request) {
                $query->where('name', 'LIKE', '%'.$request->search.'%')
                    ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                    ->orWhere('phone', 'LIKE', '%'.$request->search.'%');
            });
        }

		$lists = $result->paginate(20);

        if ($request->ajax()) {
            return view('admin.contestant.ajax-list', ['lists' => $lists])->render();    
        }

        $categories = Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();

		return view('admin.contestant.list', compact('sideBar', "categories", "lists"));
    }
}
