<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Category;
use App\ContestantAdmin;

class ContestantAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $sideBar = 'ContestantAdmins';

        $lists = ContestantAdmin::get();

        return view('admin.contestant-admins.list', compact('sideBar', "lists"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $sideBar = 'ContestantAdmins';

        $categories = Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();

        return view('admin.contestant-admins.create', compact('sideBar', "categories"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate(request(), [
            'category_id' => 'required',
            'name' => 'required',
            'email' => 'required|unique:contestant_admins',
            'password' => 'required',
        ]);

        $category_id = $request->category_id;
        $name = $request->name;
        $email = $request->email;
        $password = Hash::make($request->password);

        $store = New ContestantAdmin;
        $store->category_id = $category_id;
        $store->name = $name;
        $store->email = $email;
        $store->password = $password;
        $store->save();

        return redirect()->route('admin.contestant-admins.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sideBar = 'ContestantAdmins';

        $data = ContestantAdmin::find($id);

        $categories = Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();

        return view('admin.contestant-admins.edit', compact('sideBar', 'data', "categories"));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(request(), [
            'category_id' => 'required',
            'name' => 'required',
            'email' => 'sometimes|required|unique:contestant_admins,email,'. $id,
        ]);

        if(isset($request->change_password)){
            $this->validate(request(), [
                'password' => 'required'
            ]);

            $password = Hash::make($request->password);
        }

        $category_id = $request->category_id;
        $name = $request->name;
        $email = $request->email;

        $update = ContestantAdmin::find($id);
        $update->category_id = $category_id;
        $update->name = $name;
        $update->email = $email;

        if(isset($request->change_password)){
            $update->password = $password;
        }

        $update->save();

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return back();
    }
}
