<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Category;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $sideBar = 'Categories';

        $lists = Category::orderBy('id', 'DESC')->get();

        return view('admin.categories.list', compact('sideBar', "lists"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $sideBar = 'Categories';

        return view('admin.categories.create', compact('sideBar'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate(request(), [
            'name' => 'required',
            'message' => 'required',
            'whatsapp' => 'required',
            'status' => 'required',
            'on_payment_page' => 'required',
        ]);

        if ($request->whatsapp == 'yes') {
            $this->validate(request(), [
                'phone' => 'required'
            ]);
        }

        $name = $request->name;
        $message = $request->message;
        $phone = $request->phone;
        $whatsapp = ($request->whatsapp == 'yes' ? 1 : 0);
        $status = ($request->status == 'yes' ? 1 : 0);
        $on_payment_page = ($request->on_payment_page == 'yes' ? 1 : 0);

        $store = New Category;
        $store->name = $name;
        $store->message = $message;
        $store->phone = $phone;
        $store->whatsapp = $whatsapp;
        $store->status = $status;
        $store->on_payment_page = $on_payment_page;
        $store->save();

        return redirect()->route('admin.categories.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sideBar = 'Categories';

        $data = Category::find($id);

        return view('admin.categories.edit', compact('sideBar', 'data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(request(), [
            'name' => 'required',
            'message' => 'required',
            'whatsapp' => 'required',
            'status' => 'required',
            'on_payment_page' => 'required',
        ]);

        if ($request->whatsapp == 'yes') {
            $this->validate(request(), [
                'phone' => 'required'
            ]);
        }

        $name = $request->name;
        $message = $request->message;
        $phone = $request->phone;
        $whatsapp = ($request->whatsapp == 'yes' ? 1 : 0);
        $status = ($request->status == 'yes' ? 1 : 0);
        $on_payment_page = ($request->on_payment_page == 'yes' ? 1 : 0);

        $store = Category::find($id);
        $store->name = $name;
        $store->message = $message;
        $store->phone = $phone;
        $store->whatsapp = $whatsapp;
        $store->status = $status;
        $store->on_payment_page = $on_payment_page;
        $store->save();

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        $destroy = Category::findOrFail($id);
        $destroy->delete();
        
        return back();
    }
}
